/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoAcceptorConfig;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoServiceListener;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.common.support.IoServiceListenerSupport;
import org.easymock.MockControl;

public class IoServiceListenerSupportTest
extends TestCase {
    private static final SocketAddress ADDRESS = new InetSocketAddress(8080);

    public void testServiceLifecycle() throws Exception {
        IoServiceListenerSupport support = new IoServiceListenerSupport();
        MockControl listenerControl = MockControl.createStrictControl(IoServiceListener.class);
        IoServiceListener listener = (IoServiceListener)listenerControl.getMock();
        listener.serviceActivated(null, ADDRESS, null, null);
        listenerControl.replay();
        support.add(listener);
        support.fireServiceActivated(null, ADDRESS, null, null);
        listenerControl.verify();
        Assert.assertEquals((int)1, (int)support.getManagedServiceAddresses().size());
        Assert.assertTrue((boolean)support.getManagedServiceAddresses().contains(ADDRESS));
        listenerControl.reset();
        listener.serviceDeactivated(null, ADDRESS, null, null);
        listenerControl.replay();
        support.fireServiceActivated(null, ADDRESS, null, null);
        support.fireServiceDeactivated(null, ADDRESS, null, null);
        support.fireServiceDeactivated(null, ADDRESS, null, null);
        listenerControl.verify();
        Assert.assertEquals((int)0, (int)support.getManagedServiceAddresses().size());
        Assert.assertFalse((boolean)support.getManagedServiceAddresses().contains(ADDRESS));
    }

    public void testSessionLifecycle() throws Exception {
        IoServiceListenerSupport support = new IoServiceListenerSupport();
        TestSession session = new TestSession(ADDRESS);
        MockControl chainControl = MockControl.createStrictControl(IoFilterChain.class);
        IoFilterChain chain = (IoFilterChain)chainControl.getMock();
        session.setFilterChain(chain);
        MockControl listenerControl = MockControl.createStrictControl(IoServiceListener.class);
        IoServiceListener listener = (IoServiceListener)listenerControl.getMock();
        listener.sessionCreated(session);
        chain.fireSessionCreated(session);
        chain.fireSessionOpened(session);
        listenerControl.replay();
        chainControl.replay();
        support.add(listener);
        support.fireSessionCreated(session);
        listenerControl.verify();
        chainControl.verify();
        Assert.assertEquals((int)1, (int)support.getManagedSessions(ADDRESS).size());
        Assert.assertTrue((boolean)support.getManagedSessions(ADDRESS).contains(session));
        listenerControl.reset();
        chainControl.reset();
        chain.fireSessionClosed(session);
        listener.sessionDestroyed(session);
        listenerControl.replay();
        support.fireSessionCreated(session);
        support.fireSessionDestroyed(session);
        support.fireSessionDestroyed(session);
        listenerControl.verify();
        Assert.assertFalse((boolean)session.isClosing());
        Assert.assertEquals((int)0, (int)support.getManagedSessions(ADDRESS).size());
        Assert.assertFalse((boolean)support.getManagedSessions(ADDRESS).contains(session));
    }

    public void testDisconnectOnUnbind() throws Exception {
        final IoServiceListenerSupport support = new IoServiceListenerSupport();
        MockControl acceptorControl = MockControl.createStrictControl(IoAcceptor.class);
        IoAcceptor acceptor = (IoAcceptor)acceptorControl.getMock();
        final TestSession session = new TestSession(acceptor, ADDRESS);
        MockControl configControl = MockControl.createStrictControl(IoAcceptorConfig.class);
        IoAcceptorConfig config = (IoAcceptorConfig)configControl.getMock();
        MockControl chainControl = MockControl.createStrictControl(IoFilterChain.class);
        IoFilterChain chain = (IoFilterChain)chainControl.getMock();
        session.setFilterChain(chain);
        MockControl listenerControl = MockControl.createStrictControl(IoServiceListener.class);
        IoServiceListener listener = (IoServiceListener)listenerControl.getMock();
        listener.serviceActivated(acceptor, ADDRESS, null, config);
        listener.sessionCreated(session);
        chain.fireSessionCreated(session);
        chain.fireSessionOpened(session);
        listenerControl.replay();
        chainControl.replay();
        support.add(listener);
        support.fireServiceActivated(acceptor, ADDRESS, null, config);
        support.fireSessionCreated(session);
        listenerControl.verify();
        chainControl.verify();
        listenerControl.reset();
        chainControl.reset();
        listener.serviceDeactivated(acceptor, ADDRESS, null, config);
        configControl.expectAndReturn(config.isDisconnectOnUnbind(), true);
        listener.sessionDestroyed(session);
        chain.fireSessionClosed(session);
        listenerControl.replay();
        configControl.replay();
        chainControl.replay();
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                support.fireSessionDestroyed(session);
            }
        }.start();
        support.fireServiceDeactivated(acceptor, ADDRESS, null, config);
        Thread.sleep(1000L);
        listenerControl.verify();
        configControl.verify();
        chainControl.verify();
        Assert.assertTrue((boolean)session.isClosing());
        Assert.assertEquals((int)0, (int)support.getManagedSessions(ADDRESS).size());
        Assert.assertFalse((boolean)support.getManagedSessions(ADDRESS).contains(session));
    }

    public void testConnectorActivation() throws Exception {
        IoServiceListenerSupport support = new IoServiceListenerSupport();
        MockControl connectorControl = MockControl.createStrictControl(IoConnector.class);
        IoConnector connector = (IoConnector)connectorControl.getMock();
        TestSession session = new TestSession(connector, ADDRESS);
        MockControl chainControl = MockControl.createStrictControl(IoFilterChain.class);
        IoFilterChain chain = (IoFilterChain)chainControl.getMock();
        session.setFilterChain(chain);
        MockControl listenerControl = MockControl.createStrictControl(IoServiceListener.class);
        IoServiceListener listener = (IoServiceListener)listenerControl.getMock();
        listener.serviceActivated(connector, ADDRESS, null, null);
        listener.sessionCreated(session);
        chain.fireSessionCreated(session);
        chain.fireSessionOpened(session);
        listenerControl.replay();
        chainControl.replay();
        support.add(listener);
        support.fireSessionCreated(session);
        listenerControl.verify();
        chainControl.verify();
        listenerControl.reset();
        chainControl.reset();
        listener.sessionDestroyed(session);
        chain.fireSessionClosed(session);
        listener.serviceDeactivated(connector, ADDRESS, null, null);
        listenerControl.replay();
        chainControl.replay();
        support.fireSessionDestroyed(session);
        listenerControl.verify();
        chainControl.verify();
        Assert.assertEquals((int)0, (int)support.getManagedSessions(ADDRESS).size());
        Assert.assertFalse((boolean)support.getManagedSessions(ADDRESS).contains(session));
    }

    private static class TestSession
    extends BaseIoSession {
        private final IoService service;
        private final SocketAddress serviceAddress;
        private IoFilterChain filterChain;

        TestSession(SocketAddress serviceAddress) {
            this(null, serviceAddress);
        }

        TestSession(IoService service, SocketAddress serviceAddress) {
            this.service = service;
            this.serviceAddress = serviceAddress;
        }

        protected void updateTrafficMask() {
        }

        public IoSessionConfig getConfig() {
            return null;
        }

        public IoFilterChain getFilterChain() {
            return this.filterChain;
        }

        public void setFilterChain(IoFilterChain filterChain) {
            this.filterChain = filterChain;
        }

        public IoHandler getHandler() {
            return null;
        }

        public SocketAddress getLocalAddress() {
            return null;
        }

        public SocketAddress getRemoteAddress() {
            return null;
        }

        public int getScheduledWriteBytes() {
            return 0;
        }

        public int getScheduledWriteRequests() {
            return 0;
        }

        public IoService getService() {
            return this.service;
        }

        public SocketAddress getServiceAddress() {
            return this.serviceAddress;
        }

        public IoServiceConfig getServiceConfig() {
            return null;
        }

        public TransportType getTransportType() {
            return null;
        }
    }
}

