/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;

public class CumulativeProtocolDecoderTest
extends TestCase {
    private final IoSession session = new IoSessionImpl();
    private ByteBuffer buf;
    private IntegerDecoder decoder;
    private IntegerDecoderOutput output;

    public static void main(String[] args) {
        TestRunner.run(CumulativeProtocolDecoderTest.class);
    }

    protected void setUp() throws Exception {
        this.buf = ByteBuffer.allocate(16);
        this.decoder = new IntegerDecoder();
        this.output = new IntegerDecoderOutput();
    }

    protected void tearDown() throws Exception {
        this.decoder.dispose(this.session);
    }

    public void testCumulation() throws Exception {
        this.buf.put((byte)0);
        this.buf.flip();
        this.decoder.decode(this.session, this.buf, this.output);
        Assert.assertEquals((int)0, (int)this.output.getValues().size());
        Assert.assertEquals((int)this.buf.limit(), (int)this.buf.position());
        this.buf.clear();
        this.buf.put((byte)0);
        this.buf.put((byte)0);
        this.buf.put((byte)1);
        this.buf.flip();
        this.decoder.decode(this.session, this.buf, this.output);
        Assert.assertEquals((int)1, (int)this.output.getValues().size());
        Assert.assertEquals((Object)new Integer(1), this.output.getValues().get(0));
        Assert.assertEquals((int)this.buf.limit(), (int)this.buf.position());
    }

    public void testRepeatitiveDecode() throws Exception {
        int i = 0;
        while (i < 4) {
            this.buf.putInt(i);
            ++i;
        }
        this.buf.flip();
        this.decoder.decode(this.session, this.buf, this.output);
        Assert.assertEquals((int)4, (int)this.output.getValues().size());
        Assert.assertEquals((int)this.buf.limit(), (int)this.buf.position());
        ArrayList<Integer> expected = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < 4) {
            expected.add(new Integer(i2));
            ++i2;
        }
        Assert.assertEquals(expected, (Object)this.output.getValues());
    }

    public void testWrongImplementationDetection() throws Exception {
        try {
            new WrongDecoder().decode(this.session, this.buf, this.output);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static class IntegerDecoder
    extends CumulativeProtocolDecoder {
        private IntegerDecoder() {
        }

        protected boolean doDecode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
            Assert.assertTrue((boolean)in.hasRemaining());
            if (in.remaining() < 4) {
                return false;
            }
            out.write(new Integer(in.getInt()));
            return true;
        }

        public void dispose() throws Exception {
        }
    }

    private static class IntegerDecoderOutput
    implements ProtocolDecoderOutput {
        private List<Object> values = new ArrayList<Object>();

        private IntegerDecoderOutput() {
        }

        public void write(Object message) {
            this.values.add(message);
        }

        public List getValues() {
            return this.values;
        }

        public void clear() {
            this.values.clear();
        }

        public void flush() {
        }
    }

    private static class IoSessionImpl
    extends BaseIoSession
    implements IoSession {
        private IoSessionImpl() {
        }

        public IoHandler getHandler() {
            return null;
        }

        public ProtocolEncoder getEncoder() {
            return null;
        }

        public ProtocolDecoder getDecoder() {
            return null;
        }

        public CloseFuture close() {
            return null;
        }

        public TransportType getTransportType() {
            return TransportType.SOCKET;
        }

        public SocketAddress getRemoteAddress() {
            return null;
        }

        public SocketAddress getLocalAddress() {
            return null;
        }

        public IoFilterChain getFilterChain() {
            return null;
        }

        public int getScheduledWriteRequests() {
            return 0;
        }

        protected void updateTrafficMask() {
        }

        public boolean isClosing() {
            return false;
        }

        public IoService getService() {
            return null;
        }

        public IoServiceConfig getServiceConfig() {
            return null;
        }

        public IoSessionConfig getConfig() {
            return null;
        }

        public SocketAddress getServiceAddress() {
            return null;
        }

        public int getScheduledWriteBytes() {
            return 0;
        }
    }

    private static class WrongDecoder
    extends CumulativeProtocolDecoder {
        private WrongDecoder() {
        }

        protected boolean doDecode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
            return true;
        }

        public void dispose() throws Exception {
        }
    }
}

