/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.textline;

import java.net.SocketAddress;
import java.nio.charset.Charset;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.filter.codec.support.SimpleProtocolEncoderOutput;
import org.apache.mina.filter.codec.textline.LineDelimiter;
import org.apache.mina.filter.codec.textline.TextLineEncoder;

public class TextLineEncoderTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(TextLineEncoderTest.class);
    }

    public void testEncode() throws Exception {
        TextLineEncoder encoder = new TextLineEncoder(Charset.forName("UTF-8"), LineDelimiter.WINDOWS);
        DummySession session = new DummySession();
        SimpleProtocolEncoderOutput out = new SimpleProtocolEncoderOutput(){

            protected WriteFuture doFlush(ByteBuffer buf) {
                return null;
            }
        };
        encoder.encode(session, "ABC", out);
        Assert.assertEquals((int)1, (int)out.getBufferQueue().size());
        ByteBuffer buf = out.getBufferQueue().poll();
        Assert.assertEquals((int)5, (int)buf.remaining());
        Assert.assertEquals((int)65, (int)buf.get());
        Assert.assertEquals((int)66, (int)buf.get());
        Assert.assertEquals((int)67, (int)buf.get());
        Assert.assertEquals((int)13, (int)buf.get());
        Assert.assertEquals((int)10, (int)buf.get());
    }

    private static class DummySession
    extends BaseIoSession {
        private DummySession() {
        }

        protected void updateTrafficMask() {
        }

        public IoService getService() {
            return null;
        }

        public IoServiceConfig getServiceConfig() {
            return null;
        }

        public IoHandler getHandler() {
            return null;
        }

        public IoFilterChain getFilterChain() {
            return null;
        }

        public TransportType getTransportType() {
            return null;
        }

        public SocketAddress getRemoteAddress() {
            return null;
        }

        public SocketAddress getLocalAddress() {
            return null;
        }

        public int getScheduledWriteRequests() {
            return 0;
        }

        public IoSessionConfig getConfig() {
            return null;
        }

        public SocketAddress getServiceAddress() {
            return null;
        }

        public int getScheduledWriteBytes() {
            return 0;
        }
    }
}

