/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.executor;

import java.net.SocketAddress;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.filter.executor.ExecutorFilter;

public class ExecutorFilterRegressionTest
extends TestCase {
    private ExecutorFilter filter;

    public void setUp() throws Exception {
        this.filter = new ExecutorFilter();
    }

    public void tearDown() throws Exception {
        ((ThreadPoolExecutor)this.filter.getExecutor()).shutdown();
        this.filter = null;
    }

    public void testEventOrder() throws Throwable {
        EventOrderChecker nextFilter = new EventOrderChecker();
        EventOrderCounter[] sessions = new EventOrderCounter[]{new EventOrderCounter(), new EventOrderCounter(), new EventOrderCounter(), new EventOrderCounter(), new EventOrderCounter(), new EventOrderCounter(), new EventOrderCounter(), new EventOrderCounter(), new EventOrderCounter(), new EventOrderCounter()};
        int loop = 1000000;
        int end = sessions.length - 1;
        ExecutorFilter filter = this.filter;
        ((ThreadPoolExecutor)filter.getExecutor()).setKeepAliveTime(3L, TimeUnit.SECONDS);
        int i = 0;
        while (i < 1000000) {
            Integer objI = new Integer(i);
            int j = end;
            while (j >= 0) {
                filter.messageReceived(nextFilter, sessions[j], objI);
                --j;
            }
            if (nextFilter.throwable != null) {
                throw nextFilter.throwable;
            }
            ++i;
        }
        Thread.sleep(1000L);
        i = end;
        while (i >= 0) {
            Assert.assertEquals((int)999999, (int)sessions[i].lastCount);
            --i;
        }
    }

    public static void main(String[] args) {
        TestRunner.run(ExecutorFilterRegressionTest.class);
    }

    private static class EventOrderChecker
    implements IoFilter.NextFilter {
        private Throwable throwable;

        private EventOrderChecker() {
        }

        public void sessionOpened(IoSession session) {
        }

        public void sessionClosed(IoSession session) {
        }

        public void sessionIdle(IoSession session, IdleStatus status) {
        }

        public void exceptionCaught(IoSession session, Throwable cause) {
        }

        public void messageReceived(IoSession session, Object message) {
            block2: {
                try {
                    ((EventOrderCounter)session).setLastCount((Integer)message);
                }
                catch (Throwable t) {
                    if (this.throwable != null) break block2;
                    this.throwable = t;
                }
            }
        }

        public void messageSent(IoSession session, Object message) {
        }

        public void filterWrite(IoSession session, IoFilter.WriteRequest writeRequest) {
        }

        public void filterClose(IoSession session) {
        }

        public void sessionCreated(IoSession session) {
        }
    }

    private static class EventOrderCounter
    extends BaseIoSession {
        private Integer lastCount = null;

        private EventOrderCounter() {
        }

        public synchronized void setLastCount(Integer newCount) {
            if (this.lastCount != null) {
                Assert.assertEquals((int)(this.lastCount + 1), (int)newCount);
            }
            this.lastCount = newCount;
        }

        public IoHandler getHandler() {
            return null;
        }

        public IoFilterChain getFilterChain() {
            return null;
        }

        public CloseFuture close() {
            return null;
        }

        public TransportType getTransportType() {
            return null;
        }

        public SocketAddress getRemoteAddress() {
            return null;
        }

        public SocketAddress getLocalAddress() {
            return null;
        }

        public int getScheduledWriteRequests() {
            return 0;
        }

        protected void updateTrafficMask() {
        }

        public boolean isClosing() {
            return false;
        }

        public IoService getService() {
            return null;
        }

        public IoServiceConfig getServiceConfig() {
            return null;
        }

        public IoSessionConfig getConfig() {
            return null;
        }

        public SocketAddress getServiceAddress() {
            return null;
        }

        public int getScheduledWriteBytes() {
            return 0;
        }
    }
}

