/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.DatagramSessionConfig;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBindTest
extends TestCase {
    protected final IoAcceptor acceptor;
    protected int port;

    public AbstractBindTest(IoAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    protected abstract SocketAddress createSocketAddress(int var1);

    protected abstract int getPort(SocketAddress var1);

    protected void bind(boolean reuseAddress) throws IOException {
        this.setReuseAddress(reuseAddress);
        boolean socketBound = false;
        this.port = 1;
        while (this.port <= 65535) {
            socketBound = false;
            try {
                this.acceptor.bind(this.createSocketAddress(this.port), new EchoProtocolHandler());
                socketBound = true;
                break;
            }
            catch (IOException iOException) {
                ++this.port;
            }
        }
        if (!socketBound) {
            throw new IOException("Cannot bind any test port.");
        }
    }

    private void setReuseAddress(boolean reuseAddress) {
        if (this.acceptor instanceof DatagramAcceptor) {
            ((DatagramSessionConfig)this.acceptor.getDefaultConfig().getSessionConfig()).setReuseAddress(reuseAddress);
        } else if (this.acceptor instanceof SocketAcceptor) {
            ((SocketAcceptorConfig)this.acceptor.getDefaultConfig()).setReuseAddress(reuseAddress);
        }
    }

    public void tearDown() {
        try {
            this.acceptor.unbindAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testAnonymousBind() throws Exception {
        this.acceptor.bind(null, new IoHandlerAdapter());
        Assert.assertEquals((int)1, (int)this.acceptor.getManagedServiceAddresses().size());
        this.acceptor.unbindAll();
        Thread.sleep(500L);
        Assert.assertEquals((int)0, (int)this.acceptor.getManagedServiceAddresses().size());
        this.acceptor.bind(this.createSocketAddress(0), new IoHandlerAdapter());
        Assert.assertEquals((int)1, (int)this.acceptor.getManagedServiceAddresses().size());
        SocketAddress address = this.acceptor.getManagedServiceAddresses().iterator().next();
        Assert.assertTrue((this.getPort(address) != 0 ? 1 : 0) != 0);
        this.acceptor.unbind(address);
    }

    public void testDuplicateBind() throws IOException {
        this.bind(false);
        try {
            this.acceptor.bind(this.createSocketAddress(this.port), new EchoProtocolHandler());
            Assert.fail((String)"IOException is not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testDuplicateUnbind() throws IOException {
        this.bind(false);
        this.acceptor.unbind(this.createSocketAddress(this.port));
        try {
            this.acceptor.unbind(this.createSocketAddress(this.port));
            Assert.fail((String)"Exception is not thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testManyTimes() throws IOException {
        this.bind(true);
        SocketAddress addr = this.createSocketAddress(this.port);
        EchoProtocolHandler handler = new EchoProtocolHandler();
        int i = 0;
        while (i < 1024) {
            this.acceptor.unbind(addr);
            this.acceptor.bind(addr, handler);
            ++i;
        }
    }

    public void _testRegressively() throws IOException {
        this.setReuseAddress(true);
        SocketAddress addr = this.createSocketAddress(this.port);
        EchoProtocolHandler handler = new EchoProtocolHandler();
        int i = 0;
        while (i < 0x100000) {
            this.acceptor.bind(addr, handler);
            this.testDuplicateBind();
            this.testDuplicateUnbind();
            if (i % 100 == 0) {
                System.out.println(String.valueOf(i) + " (" + new Date() + ")");
            }
            ++i;
        }
        this.bind(false);
    }

    private static class EchoProtocolHandler
    extends IoHandlerAdapter {
        private static final Logger log = LoggerFactory.getLogger(EchoProtocolHandler.class);

        private EchoProtocolHandler() {
        }

        public void sessionCreated(IoSession session) {
            if (session.getConfig() instanceof SocketSessionConfig) {
                ((SocketSessionConfig)session.getConfig()).setReceiveBufferSize(2048);
            }
            session.setIdleTime(IdleStatus.BOTH_IDLE, 10);
        }

        public void sessionIdle(IoSession session, IdleStatus status) {
            log.info("*** IDLE #" + session.getIdleCount(IdleStatus.BOTH_IDLE) + " ***");
        }

        public void exceptionCaught(IoSession session, Throwable cause) {
            cause.printStackTrace();
            session.close();
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            if (!(message instanceof ByteBuffer)) {
                return;
            }
            ByteBuffer rb = (ByteBuffer)message;
            ByteBuffer wb = ByteBuffer.allocate(rb.remaining());
            wb.put(rb);
            wb.flip();
            session.write(wb);
        }
    }
}

