/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.ExpiringSessionRecycler;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.DatagramConnector;
import org.apache.mina.util.AvailablePortFinder;

public class DatagramRecyclerTest
extends TestCase {
    private final IoAcceptor acceptor = new DatagramAcceptor();
    private final IoConnector connector = new DatagramConnector();

    public void testDatagramRecycler() throws Exception {
        int port = AvailablePortFinder.getNextAvailable(1024);
        DatagramAcceptorConfig config = new DatagramAcceptorConfig();
        ExpiringSessionRecycler recycler = new ExpiringSessionRecycler(1, 1);
        config.setSessionRecycler(recycler);
        MockHandler acceptorHandler = new MockHandler();
        MockHandler connectorHandler = new MockHandler();
        this.acceptor.bind(new InetSocketAddress(port), acceptorHandler, config);
        try {
            ConnectFuture future = this.connector.connect((SocketAddress)new InetSocketAddress("localhost", port), connectorHandler, config);
            future.join();
            future.getSession().write(ByteBuffer.allocate(1)).join();
            future.getSession().getCloseFuture().join(3000L);
            Assert.assertTrue((boolean)future.getSession().getCloseFuture().isClosed());
            acceptorHandler.session.getCloseFuture().join(3000L);
            Assert.assertTrue((boolean)acceptorHandler.session.getCloseFuture().isClosed());
            Thread.sleep(1000L);
            Assert.assertEquals((String)"CROPSECL", (String)connectorHandler.result.toString());
            Assert.assertEquals((String)"CROPRECL", (String)acceptorHandler.result.toString());
        }
        finally {
            this.acceptor.unbind(new InetSocketAddress(port));
        }
    }

    public void testCloseRequest() throws Exception {
        int port = AvailablePortFinder.getNextAvailable(1024);
        DatagramAcceptorConfig config = new DatagramAcceptorConfig();
        ExpiringSessionRecycler recycler = new ExpiringSessionRecycler(10, 1);
        config.setSessionRecycler(recycler);
        MockHandler acceptorHandler = new MockHandler();
        MockHandler connectorHandler = new MockHandler();
        this.acceptor.bind(new InetSocketAddress(port), acceptorHandler, config);
        try {
            ConnectFuture future = this.connector.connect((SocketAddress)new InetSocketAddress("localhost", port), connectorHandler, config);
            future.join();
            future.getSession().write(ByteBuffer.allocate(1)).join();
            while (acceptorHandler.session == null) {
                Thread.yield();
            }
            acceptorHandler.session.close();
            Assert.assertTrue((boolean)acceptorHandler.session.getCloseFuture().join(3000L));
            IoSession oldSession = acceptorHandler.session;
            long startTime = System.currentTimeMillis();
            while (acceptorHandler.result.length() < 8) {
                Thread.yield();
                if (System.currentTimeMillis() - startTime <= 5000L) continue;
                throw new Exception();
            }
            acceptorHandler.result.setLength(0);
            acceptorHandler.session = null;
            future.getSession().write(ByteBuffer.allocate(1)).join();
            while (acceptorHandler.session == null) {
                Thread.yield();
            }
            acceptorHandler.session.close();
            Assert.assertTrue((boolean)acceptorHandler.session.getCloseFuture().join(3000L));
            future.getSession().close().join();
            Assert.assertNotSame((Object)oldSession, (Object)acceptorHandler.session);
        }
        finally {
            this.acceptor.unbind(new InetSocketAddress(port));
        }
    }

    private class MockHandler
    extends IoHandlerAdapter {
        public volatile IoSession session;
        public final StringBuffer result = new StringBuffer();

        private MockHandler() {
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            this.session = session;
            this.result.append("CA");
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            this.session = session;
            this.result.append("RE");
        }

        public void messageSent(IoSession session, Object message) throws Exception {
            this.session = session;
            this.result.append("SE");
        }

        public void sessionClosed(IoSession session) throws Exception {
            this.session = session;
            this.result.append("CL");
        }

        public void sessionCreated(IoSession session) throws Exception {
            this.session = session;
            this.result.append("CR");
        }

        public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
            this.session = session;
            this.result.append("ID");
        }

        public void sessionOpened(IoSession session) throws Exception {
            this.session = session;
            this.result.append("OP");
        }
    }
}

