/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import junit.framework.Assert;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.AbstractBindTest;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketConnector;

public class SocketBindTest
extends AbstractBindTest {
    public SocketBindTest() {
        super(new SocketAcceptor());
    }

    protected SocketAddress createSocketAddress(int port) {
        return new InetSocketAddress(port);
    }

    protected int getPort(SocketAddress address) {
        return ((InetSocketAddress)address).getPort();
    }

    public void testUnbindDisconnectsClients() throws Exception {
        this.bind(false);
        SocketAddress addr = this.createSocketAddress(this.port);
        SocketConnector connector = new SocketConnector();
        IoSession[] sessions = new IoSession[5];
        int i = 0;
        while (i < sessions.length) {
            ConnectFuture future = connector.connect(new InetSocketAddress("localhost", this.port), new IoHandlerAdapter());
            future.join();
            sessions[i] = future.getSession();
            Assert.assertTrue((boolean)sessions[i].isConnected());
            ++i;
        }
        Thread.sleep(500L);
        Set<IoSession> managedSessions = this.acceptor.getManagedSessions(addr);
        Assert.assertEquals((int)5, (int)managedSessions.size());
        this.acceptor.unbind(addr);
        Thread.sleep(500L);
        int i2 = 0;
        while (i2 < sessions.length) {
            Assert.assertFalse((boolean)sessions[i2].isConnected());
            ++i2;
        }
    }
}

