/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe;

import java.net.SocketAddress;
import java.util.Set;
import junit.framework.Assert;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.AbstractBindTest;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;

public class VmPipeBindTest
extends AbstractBindTest {
    public VmPipeBindTest() {
        super(new VmPipeAcceptor());
    }

    protected SocketAddress createSocketAddress(int port) {
        return new VmPipeAddress(port);
    }

    protected int getPort(SocketAddress address) {
        return ((VmPipeAddress)address).getPort();
    }

    public void testUnbindDisconnectsClients() throws Exception {
        this.bind(false);
        SocketAddress addr = this.createSocketAddress(this.port);
        VmPipeConnector connector = new VmPipeConnector();
        IoSession[] sessions = new IoSession[5];
        int i = 0;
        while (i < sessions.length) {
            ConnectFuture future = connector.connect(addr, new IoHandlerAdapter());
            future.join();
            sessions[i] = future.getSession();
            Assert.assertTrue((boolean)sessions[i].isConnected());
            ++i;
        }
        Thread.sleep(500L);
        Set<IoSession> managedSessions = this.acceptor.getManagedSessions(addr);
        Assert.assertEquals((int)5, (int)managedSessions.size());
        int i2 = 0;
        while (i2 < sessions.length) {
            Assert.assertFalse((boolean)managedSessions.contains(sessions[i2]));
            ++i2;
        }
        this.acceptor.unbind(addr);
        Thread.sleep(500L);
        i2 = 0;
        while (i2 < sessions.length) {
            Assert.assertFalse((boolean)sessions[i2].isConnected());
            ++i2;
        }
    }
}

