/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;

public class VmPipeEventOrderTest
extends TestCase {
    public void testServerToClient() throws Exception {
        VmPipeAcceptor acceptor = new VmPipeAcceptor();
        acceptor.getDefaultConfig().setThreadModel(ThreadModel.MANUAL);
        VmPipeConnector connector = new VmPipeConnector();
        connector.getDefaultConfig().setThreadModel(ThreadModel.MANUAL);
        acceptor.bind(new VmPipeAddress(1), new IoHandlerAdapter(){

            public void sessionOpened(IoSession session) throws Exception {
                session.write("B");
            }

            public void messageSent(IoSession session, Object message) throws Exception {
                session.close();
            }
        });
        final StringBuffer actual = new StringBuffer();
        ConnectFuture future = connector.connect(new VmPipeAddress(1), new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object message) throws Exception {
                actual.append(message);
            }

            public void sessionClosed(IoSession session) throws Exception {
                actual.append("C");
            }

            public void sessionOpened(IoSession session) throws Exception {
                actual.append("A");
            }
        });
        future.join();
        future.getSession().getCloseFuture().join();
        acceptor.unbindAll();
        while (actual.indexOf("C") < 0) {
            Thread.yield();
        }
        Assert.assertEquals((String)"ABC", (String)actual.toString());
    }

    public void testClientToServer() throws Exception {
        VmPipeAcceptor acceptor = new VmPipeAcceptor();
        acceptor.getDefaultConfig().setThreadModel(ThreadModel.MANUAL);
        VmPipeConnector connector = new VmPipeConnector();
        connector.getDefaultConfig().setThreadModel(ThreadModel.MANUAL);
        final StringBuffer actual = new StringBuffer();
        acceptor.bind(new VmPipeAddress(1), new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object message) throws Exception {
                actual.append(message);
            }

            public void sessionClosed(IoSession session) throws Exception {
                actual.append("C");
            }

            public void sessionOpened(IoSession session) throws Exception {
                actual.append("A");
            }
        });
        ConnectFuture future = connector.connect(new VmPipeAddress(1), new IoHandlerAdapter(){

            public void sessionOpened(IoSession session) throws Exception {
                session.write("B");
            }

            public void messageSent(IoSession session, Object message) throws Exception {
                session.close();
            }
        });
        future.join();
        future.getSession().getCloseFuture().join();
        acceptor.unbindAll();
        while (actual.indexOf("C") < 0) {
            Thread.yield();
        }
        Assert.assertEquals((String)"ABC", (String)actual.toString());
    }

    public void testSessionCreated() throws Exception {
        final Semaphore semaphore = new Semaphore(0);
        final StringBuffer stringBuffer = new StringBuffer();
        VmPipeAcceptor vmPipeAcceptor = new VmPipeAcceptor();
        vmPipeAcceptor.getDefaultConfig().setThreadModel(ThreadModel.MANUAL);
        VmPipeAddress vmPipeAddress = new VmPipeAddress(12345);
        vmPipeAcceptor.bind(vmPipeAddress, new IoHandlerAdapter(){

            public void sessionCreated(IoSession session) throws Exception {
                Thread.sleep(1000L);
                stringBuffer.append("A");
            }

            public void sessionOpened(IoSession session) throws Exception {
                stringBuffer.append("B");
            }

            public void messageReceived(IoSession session, Object message) throws Exception {
                stringBuffer.append("C");
            }

            public void sessionClosed(IoSession session) throws Exception {
                stringBuffer.append("D");
                semaphore.release();
            }
        });
        VmPipeConnector vmPipeConnector = new VmPipeConnector();
        ConnectFuture connectFuture = vmPipeConnector.connect(vmPipeAddress, new IoHandlerAdapter(){

            public void sessionOpened(IoSession session) throws Exception {
                session.write(ByteBuffer.wrap(new byte[1]));
            }
        });
        connectFuture.join();
        connectFuture.getSession().close();
        semaphore.tryAcquire(1L, TimeUnit.SECONDS);
        vmPipeAcceptor.unbind(vmPipeAddress);
        Assert.assertEquals((String)"ABCD", (String)stringBuffer.toString());
    }
}

