/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.OrderedColumn;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

public class OrderByColumn
extends OrderedColumn {
    private ResultColumn resultCol;
    private boolean ascending = true;
    private ValueNode expression;
    private OrderByList list;
    private int addedColumnOffset = -1;

    public void init(Object object) {
        this.expression = (ValueNode)object;
    }

    public String toString() {
        return "";
    }

    public void setDescending() {
        this.ascending = false;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    ResultColumn getResultColumn() {
        return this.resultCol;
    }

    ValueNode getNonRedundantExpression() {
        ColumnReference columnReference = null;
        ResultColumn resultColumn = this.resultCol;
        while (resultColumn.isRedundant()) {
            ValueNode valueNode = resultColumn.getExpression();
            if (valueNode instanceof ColumnReference) {
                columnReference = (ColumnReference)valueNode;
            }
            resultColumn = columnReference.getSource();
        }
        return resultColumn.getExpression();
    }

    public void bindOrderByColumn(ResultSetNode resultSetNode, OrderByList orderByList) throws StandardException {
        this.list = orderByList;
        if (this.expression instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)this.expression;
            this.resultCol = this.resolveColumnReference(resultSetNode, columnReference);
            this.columnPosition = this.resultCol.getColumnPosition();
        } else if (OrderByColumn.isReferedColByNum(this.expression)) {
            ResultColumnList resultColumnList = resultSetNode.getResultColumns();
            this.columnPosition = (Integer)this.expression.getConstantValueAsObject();
            this.resultCol = resultColumnList.getOrderByColumn(this.columnPosition);
            if (this.resultCol == null) {
                throw StandardException.newException("42X77", String.valueOf(this.columnPosition));
            }
        } else {
            this.resolveAddedColumn(resultSetNode);
            if (this.resultCol == null) {
                throw StandardException.newException("42878");
            }
        }
        this.resultCol.verifyOrderable();
    }

    private void resolveAddedColumn(ResultSetNode resultSetNode) {
        ResultColumnList resultColumnList = resultSetNode.getResultColumns();
        this.columnPosition = resultColumnList.size() - resultColumnList.getOrderBySelect() + this.addedColumnOffset + 1;
        this.resultCol = resultColumnList.getResultColumn(this.columnPosition);
    }

    public void pullUpOrderByColumn(ResultSetNode resultSetNode) throws StandardException {
        ResultColumnList resultColumnList = resultSetNode.getResultColumns();
        if (this.expression instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)this.expression;
            this.resultCol = resultColumnList.findResultColumnForOrderBy(columnReference.getColumnName(), columnReference.getTableNameNode());
            if (this.resultCol == null) {
                this.resultCol = (ResultColumn)this.getNodeFactory().getNode(80, columnReference.getColumnName(), columnReference, this.getContextManager());
                resultColumnList.addResultColumn(this.resultCol);
                this.addedColumnOffset = resultColumnList.getOrderBySelect();
                resultColumnList.incOrderBySelect();
            }
        } else if (!OrderByColumn.isReferedColByNum(this.expression)) {
            this.resultCol = (ResultColumn)this.getNodeFactory().getNode(80, null, this.expression, this.getContextManager());
            resultColumnList.addResultColumn(this.resultCol);
            this.addedColumnOffset = resultColumnList.getOrderBySelect();
            resultColumnList.incOrderBySelect();
        }
    }

    void resetToSourceRC() {
        this.resultCol = this.resultCol.getExpression().getSourceResultColumn();
    }

    boolean constantColumn(PredicateList predicateList) {
        ValueNode valueNode = this.resultCol.getExpression();
        return valueNode.constantExpression(predicateList);
    }

    void remapColumnReferencesToExpressions() throws StandardException {
        this.resultCol.setExpression(this.resultCol.getExpression().remapColumnReferencesToExpressions());
    }

    private static boolean isReferedColByNum(ValueNode valueNode) throws StandardException {
        if (!valueNode.isConstantExpression()) {
            return false;
        }
        return valueNode.getConstantValueAsObject() instanceof Integer;
    }

    private ResultColumn resolveColumnReference(ResultSetNode resultSetNode, ColumnReference columnReference) throws StandardException {
        Object object;
        QueryTreeNode queryTreeNode;
        ResultColumn resultColumn = null;
        int n = -1;
        if (resultSetNode instanceof SetOperatorNode && columnReference.getTableName() != null) {
            String string = columnReference.getSQLColumnName();
            throw StandardException.newException("42877", string);
        }
        if (columnReference.getTableNameNode() != null) {
            queryTreeNode = columnReference.getTableNameNode();
            object = resultSetNode.getFromTableByName(((TableName)queryTreeNode).getTableName(), ((TableName)queryTreeNode).hasSchema() ? ((TableName)queryTreeNode).getSchemaName() : null, true);
            if (object == null && (object = resultSetNode.getFromTableByName(((TableName)queryTreeNode).getTableName(), ((TableName)queryTreeNode).hasSchema() ? ((TableName)queryTreeNode).getSchemaName() : null, false)) == null) {
                String string = columnReference.getTableNameNode().toString();
                throw StandardException.newException("42X10", string);
            }
            n = resultSetNode instanceof SetOperatorNode ? ((FromTable)resultSetNode).getTableNumber() : ((FromTable)object).getTableNumber();
        }
        if ((resultColumn = ((ResultColumnList)(queryTreeNode = resultSetNode.getResultColumns())).getOrderByColumnToBind(columnReference.getColumnName(), columnReference.getTableNameNode(), n, this)) == null && this.addedColumnOffset >= 0) {
            this.resolveAddedColumn(resultSetNode);
        }
        if (resultColumn == null || resultColumn.isNameGenerated()) {
            object = columnReference.columnName;
            throw StandardException.newException("42X78", object);
        }
        return resultColumn;
    }

    void clearAddedColumnOffset() {
        this.list.closeGap(this.addedColumnOffset);
        this.addedColumnOffset = -1;
    }

    void collapseAddedColumnGap(int n) {
        if (this.addedColumnOffset > n) {
            --this.addedColumnOffset;
        }
    }
}

