/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import java.security.InvalidKeyException;
import java.security.Key;

public final class Square
extends BlockCipher {
    private static final int BLOCK_SIZE = 16;
    private static final int KEY_LENGTH = 10;
    private static final int R = 8;
    private static final byte[] SE;
    private static final byte[] SD;
    private static final int[] TE;
    private static final int[] TD;
    private static final int ROOT = 501;
    private static final int[] OFFSET;
    private int[][] sKey = new int[9][4];
    private boolean decrypt;

    static {
        int j;
        SE = new byte[256];
        SD = new byte[256];
        TE = new int[256];
        TD = new int[256];
        OFFSET = new int[8];
        byte[] exp = new byte[256];
        byte[] log = new byte[256];
        exp[0] = 1;
        int i = 1;
        while (i < 256) {
            j = exp[i - 1] << 1;
            if ((j & 0x100) != 0) {
                j ^= 0x1F5;
            }
            exp[i] = (byte)j;
            log[j & 0xFF] = (byte)i;
            ++i;
        }
        Square.SE[0] = 0;
        Square.SE[1] = 1;
        i = 2;
        while (i < 256) {
            Square.SE[i] = exp[255 - log[i] & 0xFF];
            ++i;
        }
        int[] trans = new int[]{1, 3, 5, 15, 31, 61, 123, 214};
        i = 0;
        while (i < 256) {
            int v = 177;
            j = 0;
            while (j < 8) {
                int u = SE[i] & trans[j] & 0xFF;
                u ^= u >>> 4;
                u ^= u >>> 2;
                u ^= u >>> 1;
                v ^= (u &= 1) << j;
                ++j;
            }
            Square.SE[i] = (byte)v;
            Square.SD[v] = (byte)i;
            ++i;
        }
        Square.OFFSET[0] = 1;
        i = 1;
        while (i < 8) {
            Square.OFFSET[i] = Square.mul(OFFSET[i - 1], 2);
            int n = i - 1;
            OFFSET[n] = OFFSET[n] << 24;
            ++i;
        }
        OFFSET[7] = OFFSET[7] << 24;
        i = 0;
        while (i < 256) {
            int se = SE[i] & 0xFF;
            int sd = SD[i] & 0xFF;
            Square.TE[i] = SE[i & 3] == 0 ? 0 : Square.mul(se, 2) << 24 | se << 16 | se << 8 | Square.mul(se, 3);
            Square.TD[i] = SD[i & 3] == 0 ? 0 : Square.mul(sd, 14) << 24 | Square.mul(sd, 9) << 16 | Square.mul(sd, 13) << 8 | Square.mul(sd, 11);
            ++i;
        }
    }

    public Square() {
        super(16);
    }

    protected void coreCrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        if (this.decrypt) {
            this.square(in, inOffset, out, outOffset, TD, SD);
        } else {
            this.square(in, inOffset, out, outOffset, TE, SE);
        }
    }

    protected void coreInit(Key key, boolean decrypt) throws InvalidKeyException {
        this.makeKey(key, decrypt ^ true);
        this.decrypt = decrypt;
    }

    private void makeKey(Key key, boolean doEncrypt) throws InvalidKeyException {
        byte[] userkey = key.getEncoded();
        if (userkey == null) {
            throw new InvalidKeyException("Null user key");
        }
        if (userkey.length != 16) {
            throw new InvalidKeyException("Invalid user key length");
        }
        int j = 0;
        if (doEncrypt) {
            int i = 0;
            while (i < 4) {
                this.sKey[0][i] = (userkey[j++] & 0xFF) << 24 | (userkey[j++] & 0xFF) << 16 | (userkey[j++] & 0xFF) << 8 | userkey[j++] & 0xFF;
                ++i;
            }
            i = 1;
            while (i < 9) {
                j = i - 1;
                this.sKey[i][0] = this.sKey[j][0] ^ Square.rot32L(this.sKey[j][3], 8) ^ OFFSET[j];
                this.sKey[i][1] = this.sKey[j][1] ^ this.sKey[i][0];
                this.sKey[i][2] = this.sKey[j][2] ^ this.sKey[i][1];
                this.sKey[i][3] = this.sKey[j][3] ^ this.sKey[i][2];
                Square.transform(this.sKey[j], this.sKey[j]);
                ++i;
            }
        } else {
            int[][] tKey = new int[9][4];
            int i = 0;
            while (i < 4) {
                tKey[0][i] = (userkey[j++] & 0xFF) << 24 | (userkey[j++] & 0xFF) << 16 | (userkey[j++] & 0xFF) << 8 | userkey[j++] & 0xFF;
                ++i;
            }
            i = 1;
            while (i < 9) {
                j = i - 1;
                tKey[i][0] = tKey[j][0] ^ Square.rot32L(tKey[j][3], 8) ^ OFFSET[j];
                tKey[i][1] = tKey[j][1] ^ tKey[i][0];
                tKey[i][2] = tKey[j][2] ^ tKey[i][1];
                tKey[i][3] = tKey[j][3] ^ tKey[i][2];
                ++i;
            }
            i = 0;
            while (i < 8) {
                System.arraycopy(tKey[8 - i], 0, this.sKey[i], 0, 4);
                ++i;
            }
            Square.transform(tKey[0], this.sKey[8]);
        }
    }

    private static final int mul(int a, int b) {
        if (a == 0) {
            return 0;
        }
        a &= 0xFF;
        b &= 0xFF;
        int p = 0;
        while (b != 0) {
            if ((b & 1) != 0) {
                p ^= a;
            }
            if ((a <<= 1) > 255) {
                a ^= 0x1F5;
            }
            b >>>= 1;
        }
        return p & 0xFF;
    }

    private static int rot32L(int x, int s) {
        return x << s | x >>> 32 - s;
    }

    private static int rot32R(int x, int s) {
        return x >>> s | x << 32 - s;
    }

    private void square(byte[] in, int off, byte[] out, int outOff, int[] T, byte[] S) {
        int a = (in[off++] & 0xFF) << 24 | (in[off++] & 0xFF) << 16 | (in[off++] & 0xFF) << 8 | in[off++] & 0xFF;
        int b = (in[off++] & 0xFF) << 24 | (in[off++] & 0xFF) << 16 | (in[off++] & 0xFF) << 8 | in[off++] & 0xFF;
        int c = (in[off++] & 0xFF) << 24 | (in[off++] & 0xFF) << 16 | (in[off++] & 0xFF) << 8 | in[off++] & 0xFF;
        int d = (in[off++] & 0xFF) << 24 | (in[off++] & 0xFF) << 16 | (in[off++] & 0xFF) << 8 | in[off++] & 0xFF;
        a ^= this.sKey[0][0];
        b ^= this.sKey[0][1];
        c ^= this.sKey[0][2];
        d ^= this.sKey[0][3];
        int i = 1;
        while (i < 8) {
            int aa = T[a >>> 24 & 0xFF] ^ Square.rot32R(T[b >>> 24 & 0xFF], 8) ^ Square.rot32R(T[c >>> 24 & 0xFF], 16) ^ Square.rot32R(T[d >>> 24 & 0xFF], 24) ^ this.sKey[i][0];
            int bb = T[a >>> 16 & 0xFF] ^ Square.rot32R(T[b >>> 16 & 0xFF], 8) ^ Square.rot32R(T[c >>> 16 & 0xFF], 16) ^ Square.rot32R(T[d >>> 16 & 0xFF], 24) ^ this.sKey[i][1];
            int cc = T[a >>> 8 & 0xFF] ^ Square.rot32R(T[b >>> 8 & 0xFF], 8) ^ Square.rot32R(T[c >>> 8 & 0xFF], 16) ^ Square.rot32R(T[d >>> 8 & 0xFF], 24) ^ this.sKey[i][2];
            int dd = T[a & 0xFF] ^ Square.rot32R(T[b & 0xFF], 8) ^ Square.rot32R(T[c & 0xFF], 16) ^ Square.rot32R(T[d & 0xFF], 24) ^ this.sKey[i][3];
            a = aa;
            b = bb;
            c = cc;
            d = dd;
            ++i;
        }
        i = 0;
        int j = 24;
        while (i < 4) {
            int k = (S[a >>> j & 0xFF] & 0xFF) << 24 | (S[b >>> j & 0xFF] & 0xFF) << 16 | (S[c >>> j & 0xFF] & 0xFF) << 8 | S[d >>> j & 0xFF] & 0xFF;
            out[outOff++] = (byte)((k ^= this.sKey[8][i]) >>> 24 & 0xFF);
            out[outOff++] = (byte)(k >>> 16 & 0xFF);
            out[outOff++] = (byte)(k >>> 8 & 0xFF);
            out[outOff++] = (byte)(k & 0xFF);
            ++i;
            j -= 8;
        }
    }

    private static void transform(int[] in, int[] out) {
        int i = 0;
        while (i < 4) {
            int l3 = in[i];
            int l2 = l3 >>> 8;
            int l1 = l3 >>> 16;
            int l0 = l3 >>> 24;
            int m = ((Square.mul(l0, 2) ^ Square.mul(l1, 3) ^ l2 ^ l3) & 0xFF) << 24;
            m ^= ((l0 ^ Square.mul(l1, 2) ^ Square.mul(l2, 3) ^ l3) & 0xFF) << 16;
            m ^= ((l0 ^ l1 ^ Square.mul(l2, 2) ^ Square.mul(l3, 3)) & 0xFF) << 8;
            out[i] = m ^= (Square.mul(l0, 3) ^ l1 ^ l2 ^ Square.mul(l3, 2)) & 0xFF;
            ++i;
        }
    }
}

