/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.concurrent;

public class Gate {
    private GateState state;

    public Gate() {
        this(false);
    }

    public Gate(boolean opened) {
        this.state = new GateState(opened);
    }

    public synchronized void open() {
        this.state.opened = true;
        this.notifyAll();
    }

    public synchronized void close() {
        this.state.opened = false;
    }

    public synchronized void pass() throws InterruptedException {
        while (!this.opened()) {
            this.wait();
        }
    }

    public synchronized boolean opened() {
        return this.state.opened;
    }

    private static final class GateState {
        public boolean opened;

        public GateState(boolean opened) {
            this.opened = opened;
        }
    }
}

