/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.exception;

import com.evelopers.common.util.helper.StringHelper;
import java.io.Serializable;

public abstract class CommonException
extends Exception
implements Serializable {
    protected Throwable parentException = null;

    public CommonException(String message) {
        this(null, message);
    }

    public CommonException(Throwable e) {
        this(e, null);
    }

    public CommonException(Throwable e, String message) {
        super(message);
        this.parentException = e;
    }

    public Throwable getParentException() {
        return this.parentException;
    }

    public String getTrace() {
        return StringHelper.stackTraceToString(this);
    }

    public String getParentTrace() {
        return StringHelper.stackTraceToString(this.getParentException());
    }

    public String getRootTrace() {
        return StringHelper.stackTraceToString(this.getRootException());
    }

    public Throwable getRootException() {
        Throwable parent = this.getParentException();
        if (parent != null) {
            if (parent instanceof CommonException) {
                return ((CommonException)parent).getRootException();
            }
            return parent;
        }
        return this;
    }

    public String getChainedMessage() {
        Throwable parent = this.getParentException();
        String parentChainedMessage = parent != null ? (parent instanceof CommonException ? ((CommonException)parent).getChainedMessage() : "[" + parent.getClass().getName() + "]: " + parent.getMessage()) : null;
        return "[" + this.getClass().getName() + "]: " + (this.getMessage() != null ? this.getMessage() : "<no message>") + (parentChainedMessage != null ? "\n<- " + parentChainedMessage : "");
    }

    public String getChainedTrace() {
        Throwable parent = this.getParentException();
        String parentTrace = parent != null ? (parent instanceof CommonException ? ((CommonException)parent).getChainedTrace() : StringHelper.stackTraceToString(parent)) : null;
        return parentTrace != null ? this.getTrace() + "\n" + parentTrace : this.getTrace();
    }
}

