/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.log.log4j;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class RingBufferAsyncAppender
extends AsyncAppender {
    private int bufferSize = 100;
    private RingBuffer buffer = null;
    private Level bufferDumpThreshold = Level.ERROR;
    private Level passthroughThreshold = Level.INFO;

    public void activateOptions() {
        if (this.bufferSize > 0) {
            this.buffer = new RingBuffer(this.bufferSize);
        } else {
            LogLog.warn((String)"The size of temporary buffer has not been set. Appender is disabled.");
        }
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setBufferDumpThreshold(String bufferDumpThreshold) {
        this.bufferDumpThreshold = Level.toLevel((String)bufferDumpThreshold);
    }

    public void setPassthroughThreshold(String passthroughThreshold) {
        this.passthroughThreshold = Level.toLevel((String)passthroughThreshold);
    }

    public void append(LoggingEvent loggingEvent) {
        Level level = loggingEvent.getLevel();
        if (level.isGreaterOrEqual((Priority)this.passthroughThreshold)) {
            super.append(loggingEvent);
        }
        if (!this.getThreshold().isGreaterOrEqual((Priority)this.passthroughThreshold)) {
            if (level.isGreaterOrEqual((Priority)this.bufferDumpThreshold)) {
                this.dumpBuffer();
            } else {
                this.buffer.append(loggingEvent);
            }
        }
    }

    private final void dumpBuffer() {
        super.append(new LoggingEvent("", Category.getInstance((String)((Object)((Object)this)).getClass().getName()), (Priority)this.bufferDumpThreshold, (Object)"============= START OF TEMPORARY BUFFER DUMP ============", null));
        List list = this.buffer.toList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            super.append((LoggingEvent)iterator.next());
        }
        super.append(new LoggingEvent("", Category.getInstance((String)((Object)((Object)this)).getClass().getName()), (Priority)this.bufferDumpThreshold, (Object)"============= END OF TEMPORARY BUFFER DUMP ============", null));
    }

    private class RingBuffer {
        private Object[] buffer = null;
        private int currentPointer = 0;
        private int lastPointer = 0;

        public synchronized void append(Object obj) {
            this.lastPointer = this.currentPointer;
            this.buffer[this.currentPointer++] = obj;
            if (this.currentPointer >= this.buffer.length) {
                this.currentPointer = 0;
            }
        }

        public synchronized List toList() {
            ArrayList<Object> arraylist = new ArrayList<Object>();
            int i = this.currentPointer;
            while (i != this.lastPointer) {
                if (this.buffer[i] != null) {
                    arraylist.add(this.buffer[i]);
                }
                if (++i < this.buffer.length) continue;
                i = 0;
            }
            if (this.buffer[i] != null) {
                arraylist.add(this.buffer[i]);
            }
            return arraylist;
        }

        public RingBuffer(int i) {
            this.buffer = new Object[i];
        }
    }
}

