/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MultiHashMap
extends HashMap {
    private static int sCount = 0;
    private String mName = null;

    public MultiHashMap() {
        this.setName();
    }

    public MultiHashMap(int initialCapacity) {
        super(initialCapacity);
        this.setName();
    }

    public MultiHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.setName();
    }

    public MultiHashMap(Map mapToCopy) {
        super(mapToCopy);
    }

    private void setName() {
        this.mName = "MultiMap-" + ++sCount;
    }

    public String getName() {
        return this.mName;
    }

    public Object put(Object key, Object value) {
        boolean results;
        if (value instanceof ArrayList) {
            return super.put(key, value);
        }
        ArrayList<Object> keyList = (ArrayList<Object>)super.get(key);
        if (keyList == null) {
            keyList = new ArrayList<Object>(10);
            super.put(key, keyList);
        }
        return (results = keyList.add(value)) ? value : null;
    }

    public boolean containsValue(Object value) {
        Set pairs = super.entrySet();
        if (pairs == null) {
            return false;
        }
        Iterator pairsIterator = pairs.iterator();
        while (pairsIterator.hasNext()) {
            Map.Entry keyValuePair = pairsIterator.next();
            ArrayList list = (ArrayList)keyValuePair.getValue();
            if (!list.contains(value)) continue;
            return true;
        }
        return false;
    }

    public int removeValue(Object value) {
        int removed = 0;
        Set pairs = super.entrySet();
        if (pairs != null) {
            Iterator i = pairs.iterator();
            while (i.hasNext()) {
                Map.Entry keyValuePair = i.next();
                ArrayList list = (ArrayList)keyValuePair.getValue();
                if (value instanceof ArrayList) {
                    if (!value.equals(list)) continue;
                    super.remove(keyValuePair.getKey());
                    ++removed;
                    continue;
                }
                while (list.remove(value)) {
                    ++removed;
                }
                if (list.size() != 0) continue;
                super.remove(keyValuePair.getKey());
            }
        }
        return removed;
    }

    public Object remove(Object key, Object item) {
        ArrayList valuesForKey = (ArrayList)super.get(key);
        if (valuesForKey == null) {
            return null;
        }
        valuesForKey.remove(item);
        return item;
    }

    public void clear() {
        Set pairs = super.entrySet();
        Iterator pairsIterator = pairs.iterator();
        while (pairsIterator.hasNext()) {
            Map.Entry keyValuePair = pairsIterator.next();
            ArrayList list = (ArrayList)keyValuePair.getValue();
            list.clear();
        }
        super.clear();
    }

    public void putAll(Map mapToPut) {
        super.putAll(mapToPut);
    }

    public Collection values() {
        ArrayList<Object> returnList = new ArrayList<Object>(super.size());
        Set pairs = super.entrySet();
        Iterator pairsIterator = pairs.iterator();
        while (pairsIterator.hasNext()) {
            Map.Entry keyValuePair = pairsIterator.next();
            ArrayList list = (ArrayList)keyValuePair.getValue();
            Object[] values = list.toArray();
            for (int ii = 0; ii < values.length; ++ii) {
                returnList.add(values[ii]);
            }
        }
        return returnList;
    }

    public Object clone() {
        MultiHashMap obj = (MultiHashMap)super.clone();
        obj.mName = this.mName;
        return obj;
    }
}

