/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.util.csv;

import com.evelopers.common.util.helper.StringHelper;
import java.util.ArrayList;

public class CSVDecoder {
    public static final char SCSV_DELIMETER = ',';
    private static final int SCSV_COND_IN_USUAL_TOKEN = 16;
    private static final int SCSV_COND_IN_ESCAPED_TOKEN = 32;
    private static final int SCSV_COND_ON_FIRST_ESCAPE = 64;
    private static final int SCSV_STATE_ON_DELIMETER = 2;
    private static final int SCSV_STATE_IN_TOKEN = 1;
    private static final char SCSV_ESCAPE = '\"';
    private static final String strDoubleEscape = "\"\"";
    private static final String strEscape = "\"";

    private CSVDecoder() {
    }

    public static String[] splitCSVString(String csvText) {
        char[] cText = csvText.toCharArray();
        int cTextIndex = 0;
        ArrayList<String> tokens = new ArrayList<String>();
        int condition = 0;
        int state = 2;
        int startPos = 0;
        while (true) {
            if (cTextIndex >= cText.length) {
                if (state == 2) {
                    tokens.add(new String(""));
                    break;
                }
                if (cTextIndex - 1 < startPos) break;
                if ((condition & 0x20) != 0) {
                    if ((condition & 0x40) != 0) {
                        tokens.add(new String(cText, startPos + 1, cTextIndex - startPos - 2));
                        break;
                    }
                    tokens.add(new String(cText, startPos, cTextIndex - startPos));
                    break;
                }
                tokens.add(new String(cText, startPos, cTextIndex - startPos));
                break;
            }
            switch (state) {
                case 2: {
                    if (cText[cTextIndex] == ',') {
                        tokens.add("");
                        state = 2;
                        break;
                    }
                    if (cText[cTextIndex] == '\"') {
                        state = 1;
                        condition = 32;
                        startPos = cTextIndex;
                        break;
                    }
                    state = 1;
                    condition = 16;
                    startPos = cTextIndex;
                    break;
                }
                case 1: {
                    if ((condition & 0x10) != 0) {
                        if (cText[cTextIndex] != ',') break;
                        tokens.add(new String(cText, startPos, cTextIndex - startPos));
                        state = 2;
                        condition = 0;
                        break;
                    }
                    if ((condition & 0x20) == 0) break;
                    if ((condition & 0x40) != 0) {
                        condition ^= 0x40;
                        if (cText[cTextIndex] == '\"' || cText[cTextIndex] != ',') break;
                        tokens.add(new String(cText, startPos + 1, cTextIndex - startPos - 2));
                        state = 2;
                        condition = 0;
                        break;
                    }
                    if (cText[cTextIndex] != '\"') break;
                    condition |= 0x40;
                }
            }
            ++cTextIndex;
        }
        String[] result = new String[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            result[i] = (String)tokens.get(i);
            result[i] = StringHelper.replaceAll(result[i], strDoubleEscape, strEscape);
        }
        return result;
    }
}

