/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.util.csv;

import com.evelopers.common.exception.CommonException;
import com.evelopers.common.exception.SystemException;
import com.evelopers.common.util.csv.CSVEncoder;
import com.evelopers.common.util.csv.iterator.ExportIterator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;

public class CSVFileEncoder {
    public static final String HALT_PROCESS = "haltOnAnyException";
    public static final String FILE_FORMAT = "fileFormat";
    protected boolean haltProcess = true;
    String[] format = null;
    Properties properties;
    protected EncoderState state = new EncoderState();
    protected DataModel data = new DataModel();

    public CSVFileEncoder() {
        this.properties = new Properties();
    }

    public CSVFileEncoder(Properties properties) {
        this.setProperties(properties);
    }

    public void export(File file, Object[] objects) throws CommonException {
        try {
            this.export(new PrintWriter(new FileWriter(file)), objects);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe, "Error exporting data.");
        }
    }

    public void export(File file, ExportIterator iterator) throws CommonException {
        try {
            this.export(new PrintWriter(new FileWriter(file)), iterator);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe, "Error exporting data.");
        }
    }

    public void export(File file, ExportIterator iterator, Class beanClass) throws CommonException {
        try {
            this.export(new PrintWriter(new FileWriter(file)), iterator);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe, "Error exporting data.");
        }
    }

    public void export(OutputStream os, Object[] objects) throws CommonException {
        this.export(new PrintWriter(os), objects);
    }

    public void export(OutputStream os, Collection objects) throws CommonException {
        this.export(new PrintWriter(os), objects);
    }

    public void export(OutputStream os, ExportIterator iterator) throws CommonException {
        this.export(new PrintWriter(os), iterator);
    }

    public void export(OutputStream os, ExportIterator iterator, Class beanClass) throws CommonException {
        this.export(new PrintWriter(os), iterator);
    }

    public void export(PrintWriter writer, Object[] objects) throws CommonException {
        this.state.init();
        this.data.init();
        if (objects == null || objects.length == 0) {
            return;
        }
        if (this.format == null) {
            throw new SystemException("Format is undefined");
        }
        int l = objects.length;
        for (int i = 0; i < l; ++i) {
            try {
                String[] tokens = this.objectToTokens(objects[i]);
                this.data.addObject(tokens);
                this.state.objectExported();
                continue;
            }
            catch (Exception e) {
                if (this.haltProcess) {
                    this.state.interrupt();
                    break;
                }
                this.state.failedToExportObject(i + 1, e);
            }
        }
        try {
            CSVEncoder.export((CSVEncoder.DataModel)this.data, writer);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe, "Error exporting data.");
        }
    }

    public void export(PrintWriter writer, Collection objects) throws CommonException {
        this.state.init();
        this.data.init();
        if (objects == null || objects.size() == 0) {
            return;
        }
        if (this.format == null) {
            throw new SystemException("Format is undefined");
        }
        int i = 0;
        Iterator iter = objects.iterator();
        while (iter.hasNext()) {
            try {
                String[] tokens = this.objectToTokens(iter.next());
                this.data.addObject(tokens);
                this.state.objectExported();
            }
            catch (Exception e) {
                if (this.haltProcess) {
                    this.state.interrupt();
                    throw new SystemException(e);
                }
                this.state.failedToExportObject(i + 1, e);
            }
            ++i;
        }
        try {
            CSVEncoder.export((CSVEncoder.DataModel)this.data, writer);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe, "Error exporting data.");
        }
    }

    public void export(PrintWriter writer, ExportIterator iterator) throws CommonException {
        this.state.init();
        this.data.init();
        if (iterator == null) {
            return;
        }
        if (this.format == null) {
            throw new SystemException("Format is undefined");
        }
        int i = 0;
        Map row = iterator.next();
        while (row != null) {
            try {
                String[] tokens = this.mapToTokens(row);
                this.data.addObject(tokens);
                this.state.objectExported();
            }
            catch (Exception e) {
                if (this.haltProcess) {
                    this.state.interrupt();
                    throw new SystemException(e);
                }
                this.state.failedToExportObject(i + 1, e);
            }
            row = iterator.next();
            ++i;
        }
        try {
            CSVEncoder.export((CSVEncoder.DataModel)this.data, writer);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe, "Error exporting data.");
        }
    }

    public void export(PrintWriter writer, ExportIterator iterator, Class beanClass) throws CommonException {
        Object row;
        this.state.init();
        this.data.init();
        if (iterator == null) {
            return;
        }
        if (this.format == null) {
            throw new SystemException("Format is undefined");
        }
        int i = 0;
        while ((row = iterator.next(beanClass)) != null) {
            try {
                String[] tokens = this.objectToTokens(row);
                this.data.addObject(tokens);
                this.state.objectExported();
                ++i;
            }
            catch (Exception e) {
                if (this.haltProcess) {
                    this.state.interrupt();
                    throw new SystemException(e);
                }
                this.state.failedToExportObject(i + 1, e);
            }
        }
        try {
            CSVEncoder.export((CSVEncoder.DataModel)this.data, writer);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe, "Error exporting data.");
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        String str = properties.getProperty(HALT_PROCESS);
        this.haltProcess = str != null && Boolean.valueOf(str) != false;
        StringTokenizer st = new StringTokenizer(properties.getProperty(FILE_FORMAT), ",; ");
        this.format = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            this.format[i] = st.nextToken();
            ++i;
        }
    }

    public EncoderState getState() {
        return this.state;
    }

    protected String[] objectToTokens(Object object) throws CommonException {
        String[] list = new String[this.format.length];
        int l = this.format.length;
        for (int i = 0; i < l; ++i) {
            try {
                list[i] = BeanUtils.getProperty((Object)object, (String)this.format[i]);
                continue;
            }
            catch (IllegalAccessException iae) {
                throw new SystemException(iae, "Failed to get bean's properties, access error on property '" + this.format[i] + "'.");
            }
            catch (InvocationTargetException ite) {
                throw new SystemException(ite, "Failed to get bean's properties, invocation error on property '" + this.format[i] + "'.");
            }
            catch (NoSuchMethodException nsme) {
                throw new SystemException(nsme, "Failed to get bean's properties, no property '" + this.format[i] + "' specified.");
            }
        }
        return list;
    }

    protected String[] mapToTokens(Map map) throws CommonException {
        String[] list = new String[this.format.length];
        int l = this.format.length;
        for (int i = 0; i < l; ++i) {
            list[i] = ConvertUtils.convert(map.get(this.format[i]));
        }
        return list;
    }

    public class DataModel
    implements CSVEncoder.DataModel {
        private ArrayList lines = new ArrayList();

        protected void init() {
            this.lines = new ArrayList();
        }

        protected void addObject(String[] tokens) {
            this.lines.add(tokens);
        }

        public Object get(int column, int row) throws CommonException {
            if (row >= this.lines.size()) {
                throw new IndexOutOfBoundsException("Row number (" + row + ") is out of range");
            }
            String[] tokens = (String[])this.lines.get(row);
            if (tokens == null || tokens.length <= column) {
                throw new IndexOutOfBoundsException("Column number (" + column + " is out of range");
            }
            return tokens[column];
        }

        public int getColumnCount() throws CommonException {
            if (CSVFileEncoder.this.format != null) {
                return CSVFileEncoder.this.format.length;
            }
            return -1;
        }

        public String getColumnName(int column) throws CommonException {
            if (CSVFileEncoder.this.format != null) {
                return CSVFileEncoder.this.format[column];
            }
            return null;
        }

        public int getFlushCount() throws CommonException {
            return -1;
        }

        public int getRowCount() throws CommonException {
            if (this.lines != null) {
                return this.lines.size();
            }
            return 0;
        }

        public boolean needHeader() throws CommonException {
            return false;
        }
    }

    public class ExportError
    extends Exception {
        int objectNumber = 0;
        Exception exception = null;

        protected ExportError(int number, Exception e) {
            this.objectNumber = number;
            this.exception = e;
        }

        public String getMessage() {
            StringBuffer sb = new StringBuffer("Failed to export object ");
            if (this.objectNumber >= 0) {
                sb.append(this.objectNumber).append(" ");
            }
            sb.append("due to error: " + (this.exception != null ? this.exception.getMessage() : "unknown"));
            return sb.toString();
        }
    }

    public class EncoderState {
        public static final int OK = 0;
        public static final int INTERRUPTED = 1;
        public static final int ERROR = 2;
        private int state = 0;
        private int objectsExported = 0;
        private ArrayList errors = null;

        protected void init() {
            this.state = 0;
            this.objectsExported = 0;
            this.errors = null;
        }

        protected void objectExported() {
            ++this.objectsExported;
        }

        protected void failedToExportObject(int number, Exception e) {
            if (this.errors == null) {
                this.errors = new ArrayList();
            }
            this.errors.add(new ExportError(number, e));
            this.state = 2;
        }

        protected void interrupt() {
            this.state = 1;
        }

        public int getState() {
            return this.state;
        }

        public boolean isOK() {
            return this.state == 0;
        }

        public int objectsExported() {
            return this.objectsExported;
        }

        public ExportError[] getErrors() {
            return this.errors.toArray(new ExportError[this.errors.size()]);
        }
    }
}

