/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.util.csv.iterator;

import com.evelopers.common.exception.CommonException;
import com.evelopers.common.exception.SystemException;
import com.evelopers.common.util.csv.iterator.ExportIterator;
import com.evelopers.common.util.db.SQLUtil;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ResultSetIterator
implements ExportIterator {
    ResultSet resultSet;
    ResultSetMetaData metadata;
    String[] format;

    public ResultSetIterator(ResultSet resultSet) {
        this.resultSet = resultSet;
        try {
            this.metadata = resultSet.getMetaData();
            if (this.metadata == null || this.metadata.getColumnCount() == 0) {
                this.format = new String[0];
                return;
            }
            this.format = new String[this.metadata.getColumnCount()];
            for (int i = 0; i < this.format.length; ++i) {
                try {
                    this.format[i] = this.metadata.getColumnName(i + 1);
                    continue;
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace(System.err);
                }
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace(System.err);
        }
    }

    public Object next(Class beanClass) throws CommonException {
        throw new SystemException("Not Implemented");
    }

    public Map next() throws CommonException {
        try {
            if (!this.resultSet.next()) {
                return null;
            }
            HashMap<String, Object> values = new HashMap<String, Object>(this.format.length);
            for (int i = 0; i < this.format.length; ++i) {
                values.put(this.format[i], this.resultSet.getObject(this.format[i]));
            }
            return values;
        }
        catch (SQLException e) {
            throw new SystemException(e, e.getMessage());
        }
    }

    public void close() throws CommonException {
        try {
            SQLUtil.closeConnection(this.resultSet);
        }
        catch (SQLException e) {
            throw new SystemException(e, e.getMessage());
        }
    }

    public String[] getHeaders() throws CommonException {
        try {
            String[] headers = new String[this.resultSet.getMetaData().getColumnCount()];
            for (int i = 0; i < this.resultSet.getMetaData().getColumnCount(); ++i) {
                headers[i] = this.resultSet.getMetaData().getColumnName(i);
            }
            return headers;
        }
        catch (SQLException e) {
            throw new SystemException(e, e.getMessage());
        }
    }
}

