/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.util.csv.validators;

import com.evelopers.common.exception.ValidationError;
import com.evelopers.common.util.csv.TokenValidator;
import java.util.Properties;

public class GenericValidator
extends TokenValidator {
    public static final String MIN = "min";
    public static final String MAX = "max";

    public void validate(String test, String token, Properties parameters) throws ValidationError {
        boolean resultOK = true;
        if (test.equals("required")) {
            resultOK = this.validateRequired(token);
        } else if (test.equals("minLength")) {
            resultOK = this.validateMinLength(token, parameters);
        } else if (test.equals("maxLength")) {
            resultOK = this.validateMaxLength(token, parameters);
        } else if (test.equals("intRange")) {
            resultOK = this.validateIntRange(token, parameters);
        } else if (test.equals("floatRange")) {
            resultOK = this.validateFloatRange(token, parameters);
        } else if (test.equals("doubleRange")) {
            resultOK = this.validateDoubleRange(token, parameters);
        } else {
            throw new ValidationError(0, test);
        }
        if (!resultOK) {
            throw new ValidationError(test, token);
        }
    }

    protected boolean validateRequired(String token) {
        return token != null && token.trim().length() > 0;
    }

    protected boolean validateEmpty(String token) {
        return token != null && token.trim().length() > 0;
    }

    protected boolean validateIntRange(String token, Properties parameters) {
        if (token != null && token.trim().length() > 0) {
            try {
                int intValue = Integer.parseInt(token);
                int min = Integer.parseInt(parameters.getProperty(MIN));
                int max = Integer.parseInt(parameters.getProperty(MAX));
                if (intValue < min || intValue > max) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    protected boolean validateFloatRange(String token, Properties parameters) {
        if (token != null && token.trim().length() > 0) {
            try {
                float floatValue = Float.parseFloat(token);
                float min = Float.parseFloat(parameters.getProperty(MIN));
                float max = Float.parseFloat(parameters.getProperty(MAX));
                if (floatValue < min || floatValue > max) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    protected boolean validateDoubleRange(String token, Properties parameters) {
        if (token != null && token.trim().length() > 0) {
            try {
                double doubleValue = Double.parseDouble(token);
                double min = Double.parseDouble(parameters.getProperty(MIN));
                double max = Double.parseDouble(parameters.getProperty(MAX));
                if (doubleValue < min || doubleValue > max) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    protected boolean validateMinLength(String token, Properties parameters) {
        if (token != null) {
            try {
                int min = Integer.parseInt(parameters.getProperty(MIN));
                if (token.length() < min) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    protected boolean validateMaxLength(String token, Properties parameters) {
        if (token != null) {
            try {
                int max = Integer.parseInt(parameters.getProperty(MAX));
                if (token.length() > max) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

