/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.util.csv.validators;

import com.evelopers.common.exception.ValidationError;
import com.evelopers.common.util.csv.TokenValidator;
import java.util.Properties;

public class SimpleTypeValidator
extends TokenValidator {
    public void validate(String test, String token, Properties parameters) throws ValidationError {
        boolean resultOK = true;
        if (test.equals("byte")) {
            resultOK = this.validateByte(token);
        } else if (test.equals("double")) {
            resultOK = this.validateDouble(token);
        } else if (test.equals("float")) {
            resultOK = this.validateFloat(token);
        } else if (test.equals("integer")) {
            resultOK = this.validateInteger(token);
        } else if (test.equals("long")) {
            resultOK = this.validateLong(token);
        } else if (test.equals("short")) {
            resultOK = this.validateShort(token);
        } else {
            throw new ValidationError(0, test);
        }
        if (!resultOK) {
            throw new ValidationError(test, token);
        }
    }

    protected boolean validateByte(String token) {
        if (token == null) {
            return false;
        }
        try {
            new Byte(token);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean validateDouble(String token) {
        if (token == null) {
            return false;
        }
        try {
            new Double(token);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean validateInteger(String token) {
        if (token == null) {
            return false;
        }
        try {
            new Integer(token);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean validateLong(String token) {
        if (token == null) {
            return false;
        }
        try {
            new Long(token);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean validateShort(String token) {
        if (token == null) {
            return false;
        }
        try {
            new Short(token);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean validateFloat(String token) {
        if (token == null) {
            return false;
        }
        try {
            new Float(token);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

