/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.util.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;

public class SQLUtil {
    public static void closeConnection(ResultSet rs) throws SQLException {
        Statement st = rs.getStatement();
        SQLUtil.closeConnection(st.getConnection(), st, rs);
    }

    public static void closeConnection(Connection con, Statement stmt, ResultSet rs) throws SQLException {
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (con != null && !con.isClosed()) {
            con.close();
        }
    }

    public static void forceCloseConnection(Connection con) {
        try {
            if (con != null && !con.isClosed()) {
                con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void forceCloseConnection(Connection con, Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        SQLUtil.forceCloseConnection(con);
    }

    public static void stmtSetString(PreparedStatement pStmt, int index, String value) throws SQLException {
        if (pStmt != null) {
            if (value != null) {
                pStmt.setString(index, value);
            } else {
                pStmt.setNull(index, 12);
            }
        }
    }

    public static void stmtSetDate(PreparedStatement pStmt, int index, Date value) throws SQLException {
        if (pStmt != null) {
            if (value != null) {
                pStmt.setTimestamp(index, new Timestamp(value.getTime()));
            } else {
                pStmt.setNull(index, 91);
            }
        }
    }

    public static void stmtSetDate(PreparedStatement pStmt, int index, java.sql.Date value) throws SQLException {
        if (pStmt != null) {
            if (value != null) {
                pStmt.setDate(index, value);
            } else {
                pStmt.setNull(index, 91);
            }
        }
    }

    public static void stmtSetLong(PreparedStatement pStmt, int index, long value) throws SQLException {
        if (pStmt != null) {
            pStmt.setLong(index, value);
        }
    }

    public static void stmtSetLong(PreparedStatement pStmt, int index, Number value) throws SQLException {
        if (pStmt != null) {
            if (value != null) {
                pStmt.setLong(index, value.longValue());
            } else {
                pStmt.setNull(index, 4);
            }
        }
    }

    public static void stmtSetInt(PreparedStatement pStmt, int index, int value) throws SQLException {
        if (pStmt != null) {
            pStmt.setInt(index, value);
        }
    }

    public static void stmtSetInt(PreparedStatement pStmt, int index, Number value) throws SQLException {
        if (pStmt != null) {
            if (value != null) {
                pStmt.setInt(index, value.intValue());
            } else {
                pStmt.setNull(index, 4);
            }
        }
    }

    public static void stmtSetDouble(PreparedStatement pStmt, int index, double value) throws SQLException {
        if (pStmt != null) {
            pStmt.setDouble(index, value);
        }
    }

    public static void stmtSetDouble(PreparedStatement pStmt, int index, Number value) throws SQLException {
        if (pStmt != null) {
            if (value != null) {
                pStmt.setDouble(index, value.doubleValue());
            } else {
                pStmt.setNull(index, 8);
            }
        }
    }
}

