/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.util.helper;

import com.evelopers.common.exception.LogicException;
import com.evelopers.common.exception.SystemException;
import com.evelopers.common.util.helper.StringHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;

public class ClassHelper {
    private static final String EMSG_TMPL_SETTER_MISSING = "Setter for property can't be found (Class:{0}; prop:{1})";
    static /* synthetic */ Class class$com$evelopers$common$util$helper$ClassHelper;

    private ClassHelper() {
    }

    public static final Class loadClass(String className) throws SystemException {
        try {
            ClassLoader cl;
            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
            Class<?> oClass = null;
            if (tcl != null) {
                try {
                    oClass = tcl.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (oClass == null && (cl = (class$com$evelopers$common$util$helper$ClassHelper == null ? (class$com$evelopers$common$util$helper$ClassHelper = ClassHelper.class$("com.evelopers.common.util.helper.ClassHelper")) : class$com$evelopers$common$util$helper$ClassHelper).getClassLoader()) != null) {
                try {
                    oClass = cl.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (oClass == null) {
                oClass = ClassLoader.getSystemClassLoader().loadClass(className);
            }
            return oClass;
        }
        catch (ClassNotFoundException e) {
            throw new SystemException(e, "Can't load class [" + className + "]");
        }
    }

    public static final Object instantiate(String cName, Class[] paramClasses, Object[] params, Class clazz) throws LogicException, SystemException {
        Object obj = ClassHelper.instantiate(cName, paramClasses, params);
        if (!clazz.isInstance(obj)) {
            throw new LogicException("Class " + cName + " is of incorrect class");
        }
        return obj;
    }

    public static final Object instantiate(String cName, Class[] paramClasses, Object[] params) throws LogicException, SystemException {
        Class clazz = ClassHelper.loadClass(cName);
        try {
            if (paramClasses != null) {
                Constructor clazzConstructor = clazz.getConstructor(paramClasses);
                if (params == null) {
                    return clazzConstructor.newInstance(new Object[paramClasses.length]);
                }
                if (params.length != paramClasses.length) {
                    throw new LogicException("lengths of param and paramClassses arrays must be the same");
                }
                return clazzConstructor.newInstance(params);
            }
            return ClassHelper.instantiate(cName, params);
        }
        catch (NoSuchMethodException e) {
            throw new SystemException(e, "Can't instaciate class");
        }
        catch (SecurityException e) {
            throw new SystemException(e, "Can't instaciate class");
        }
        catch (InstantiationException e) {
            throw new SystemException(e, "Can't instaciate class");
        }
        catch (IllegalAccessException e) {
            throw new SystemException(e, "Can't instaciate class");
        }
        catch (IllegalArgumentException e) {
            throw new SystemException(e, "Can't instaciate class");
        }
        catch (InvocationTargetException e) {
            throw new SystemException(e.getTargetException(), "Can't instaciate class");
        }
    }

    public static final Object instantiate(String cName, Object[] params, Class clazz) throws LogicException, SystemException {
        Object obj = ClassHelper.instantiate(cName, params);
        if (!clazz.isInstance(obj)) {
            throw new LogicException("Class " + cName + " is of incorrect class");
        }
        return obj;
    }

    public static final Object instantiate(String cName, Object[] params) throws SystemException {
        Class clazz = ClassHelper.loadClass(cName);
        try {
            if (params != null) {
                Class[] paramClasses = new Class[params.length];
                for (int i = 0; i < params.length; ++i) {
                    paramClasses[i] = params[i].getClass();
                }
                Constructor clazzConstructor = clazz.getConstructor(paramClasses);
                Object obj = clazzConstructor.newInstance(params);
                return obj;
            }
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (NoSuchMethodException e) {
            throw new SystemException(e, "Can't instaciate class");
        }
        catch (SecurityException e) {
            throw new SystemException(e, "Can't instaciate class");
        }
        catch (InstantiationException e) {
            throw new SystemException(e, "Can't instaciate class");
        }
        catch (IllegalAccessException e) {
            throw new SystemException(e, "Can't instaciate class");
        }
        catch (IllegalArgumentException e) {
            throw new SystemException(e, "Can't instaciate class");
        }
        catch (InvocationTargetException e) {
            throw new SystemException(e.getTargetException(), "Can't instaciate class");
        }
    }

    public static final Object invoke(Object o, String methodName, Object[] parameters) throws SystemException {
        Class[] parameterTypes;
        if (parameters == null || parameters.length == 0) {
            parameterTypes = new Class[]{};
        } else {
            parameterTypes = new Class[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                parameterTypes[i] = parameters[i].getClass();
            }
        }
        return ClassHelper.invoke(o, methodName, parameterTypes, parameters);
    }

    public static final Object invoke(Object o, String methodName, Class[] parameterTypes, Object[] parameters) throws SystemException {
        if (o == null || StringHelper.isEmpty(methodName)) {
            throw new IllegalArgumentException("Object to invoke method on can't be null, method name can't be empty.");
        }
        if (parameterTypes != null && parameters != null && parameterTypes.length != parameters.length) {
            throw new IllegalArgumentException("Different length of arrays with parameter types and parameters itself.");
        }
        Class<?> cl = o.getClass();
        try {
            Method method = cl.getMethod(methodName, parameterTypes);
            if (parameters == null) {
                parameters = new Object[]{};
            }
            return method.invoke(o, parameters);
        }
        catch (NoSuchMethodException e) {
            throw new SystemException(e, "Can't invoke method.");
        }
        catch (SecurityException e) {
            throw new SystemException(e, "Can't invoke method.");
        }
        catch (IllegalAccessException e) {
            throw new SystemException(e, "Can't invoke method.");
        }
        catch (IllegalArgumentException e) {
            throw new SystemException(e, "Can't invoke method.");
        }
        catch (InvocationTargetException e) {
            throw new SystemException(e.getTargetException(), "Exception occured inside the method.");
        }
    }

    public static final URL getResource(String resource) {
        ClassLoader classLoader = null;
        URL url = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
                return url;
            }
            classLoader = (class$com$evelopers$common$util$helper$ClassHelper == null ? (class$com$evelopers$common$util$helper$ClassHelper = ClassHelper.class$("com.evelopers.common.util.helper.ClassHelper")) : class$com$evelopers$common$util$helper$ClassHelper).getClassLoader();
            if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
                return url;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ClassLoader.getSystemResource(resource);
    }

    public static final Method getMethod(Object obj, String mName, Class[] paramTypes) throws SystemException {
        if (obj == null) {
            throw new IllegalArgumentException("Object to find method in, can't be null");
        }
        if (StringHelper.isEmpty(mName)) {
            throw new IllegalArgumentException("Method name can't be null or empty");
        }
        try {
            return obj.getClass().getMethod(mName, paramTypes);
        }
        catch (Exception e) {
            throw new SystemException(e, "Can't get method '" + mName + "' from object (" + obj.getClass().getName() + ")");
        }
    }

    public static final String createSetterName(String propertyName) {
        if (StringHelper.isEmpty(propertyName)) {
            throw new IllegalArgumentException("Can't construct setter name");
        }
        char[] tmp = propertyName.toCharArray();
        tmp[0] = Character.toUpperCase(tmp[0]);
        return "set" + new String(tmp);
    }

    public static final String createGetterName(String propertyName) {
        if (StringHelper.isEmpty(propertyName)) {
            throw new IllegalArgumentException("Can't construct setter name");
        }
        char[] tmp = propertyName.toCharArray();
        tmp[0] = Character.toUpperCase(tmp[0]);
        return "get" + new String(tmp);
    }

    public static final Class getSetterParameterType(Object obj, String propertyName) throws NoSuchMethodException {
        if (obj == null) {
            throw new IllegalArgumentException("Specified instance is null");
        }
        String sName = ClassHelper.createSetterName(propertyName);
        Method[] methods = obj.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(sName) || method.getParameterTypes().length != 1) continue;
            return method.getParameterTypes()[0];
        }
        throw new NoSuchMethodException(MessageFormat.format(EMSG_TMPL_SETTER_MISSING, obj.getClass(), propertyName));
    }

    public static final Class getFieldType(Object obj, String fieldName) throws NoSuchFieldException {
        if (obj == null) {
            throw new IllegalArgumentException("Specified instance is null");
        }
        if (StringHelper.isEmpty(fieldName)) {
            throw new IllegalArgumentException("Invalid field's name");
        }
        Field field = obj.getClass().getDeclaredField(fieldName);
        return field.getType();
    }

    public static final String getClassName(Class clazz) {
        if (clazz == null) {
            return "null";
        }
        String fullName = clazz.getName();
        int lastDotIndex = fullName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return fullName;
        }
        return fullName.substring(lastDotIndex + 1);
    }

    public static final String getClassName(Object obj) {
        if (obj == null) {
            return "null";
        }
        return ClassHelper.getClassName(obj.getClass());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

