/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.common.util.property;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertiesHelper {
    public static final char DEF_DELIMETER_CHR = '.';

    public static final Properties byPrefix(Properties props, String prefix) {
        return PropertiesHelper.byPrefix(props, prefix, true, '.');
    }

    public static final Properties byPrefix(Properties props, String prefix, boolean cut) {
        return PropertiesHelper.byPrefix(props, prefix, cut, '.');
    }

    public static final Properties byPrefix(Properties props, String prefix, boolean cut, char delimeter) {
        if (prefix == null || prefix.length() == 0) {
            return props;
        }
        Properties result = new Properties();
        prefix = PropertiesHelper.fullPrefix(prefix, delimeter);
        int pLength = prefix.length();
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!name.startsWith(prefix)) continue;
            if (cut) {
                result.setProperty(name.substring(pLength), props.getProperty(name));
                continue;
            }
            result.setProperty(name, props.getProperty(name));
        }
        return result;
    }

    public static final Properties extendPrefix(Properties props, String prefix, char delimeter) {
        if (prefix == null || prefix.length() == 0) {
            return props;
        }
        Properties result = new Properties();
        prefix = PropertiesHelper.fullPrefix(prefix, delimeter);
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            result.setProperty(prefix + name, props.getProperty(name));
        }
        return result;
    }

    public static final Map group(Properties props) {
        return PropertiesHelper.group(props, null, 1, '.');
    }

    public static final Map group(Properties props, String prefix) {
        return PropertiesHelper.group(props, prefix, 1, '.');
    }

    public static final Map group(Properties props, String prefix, int level, char delimeter) {
        Properties cutted = PropertiesHelper.byPrefix(props, prefix, true);
        return PropertiesHelper.group(cutted, level, delimeter);
    }

    public static final Map group(Properties props, int level) {
        return PropertiesHelper.group(props, level, '.');
    }

    public static final Map group(Properties props, int level, char delimeter) {
        if (props == null) {
            return new Properties();
        }
        HashMap<String, Properties> result = new HashMap<String, Properties>();
        Set prfxs = PropertiesHelper.prefixes(props, level, delimeter);
        Iterator iter = prfxs.iterator();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            Properties group = PropertiesHelper.byPrefix(props, prefix, true);
            result.put(prefix, group);
        }
        return result;
    }

    public static final Set prefixes(Properties props) {
        return PropertiesHelper.prefixes(props, 1, '.');
    }

    public static final Set prefixes(Properties props, char delimeter) {
        return PropertiesHelper.prefixes(props, 1, delimeter);
    }

    public static final Set prefixes(Properties props, int level) {
        return PropertiesHelper.prefixes(props, level, '.');
    }

    public static final Set prefixes(Properties props, int level, char delimeter) {
        HashSet<String> result = new HashSet<String>();
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            String prefix = PropertiesHelper.getPrefix(name, level, delimeter);
            result.add(prefix);
        }
        return result;
    }

    private static final String getPrefix(String str, int level, char delimeter) {
        int sIndex = -1;
        for (int i = 0; i < level && (sIndex = str.indexOf(delimeter, sIndex + 1)) != -1; ++i) {
        }
        if (sIndex == -1) {
            return str;
        }
        return PropertiesHelper.normalPrefix(str.substring(0, sIndex + 1), delimeter);
    }

    private static final String normalPrefix(String prefix, char delimeter) {
        if (prefix == null) {
            return prefix;
        }
        String strDelimeter = new String(new char[]{delimeter});
        if (prefix.endsWith(strDelimeter)) {
            return prefix.substring(0, prefix.length() - strDelimeter.length());
        }
        return prefix;
    }

    private static final String fullPrefix(String prefix, char delimeter) {
        if (prefix == null) {
            return prefix;
        }
        String strDelimeter = new String(new char[]{delimeter});
        if (prefix.endsWith(strDelimeter)) {
            return prefix;
        }
        StringBuffer tmp = new StringBuffer(prefix);
        tmp.append(strDelimeter);
        return tmp.toString();
    }
}

