/**
 * Cleversafe open-source code header - Version 1.1 - December 1, 2006
 *
 * Cleversafe Dispersed Storage(TM) is software for secure, private and
 * reliable storage of the world's data using information dispersal.
 *
 * Copyright (C) 2005-2007 Cleversafe, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 *
 * Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
 * Chicago IL 60616
 * email licensing@cleversafe.org
 *
 * Author: Greg Dhuse <gdhuse@cleversafe.com>
 *
 */

#ifndef DSD_WIN_H
#define DSD_WIN_H

#include <ntifs.h>
#include <ntstrsafe.h>

#include "dsd_win_common.h"

#include <devguid.h>
#include <mountmgr.h>
#include <mountdev.h>
#include <ntddvol.h>
#include <ntdddisk.h>

#define DSD_TAG                    "dsd: "
#define DSBLOCK_BUS_DEVICE_NAME    L"\\Device\\Dsbus"
#define DSD_DEVICE_NAME            L"\\Device\\Dsd"
#define DSD_DEVICE_NAME_LENGTH     128

typedef struct _DSD_REQUEST_CONTEXT
{
   int tag;    // Tag used to associate requests and responses

} DSD_REQUEST_CONTEXT, *PDSD_REQUEST_CONTEXT;
WDF_DECLARE_CONTEXT_TYPE_WITH_NAME( DSD_REQUEST_CONTEXT, GetRequestContext );

// Driver initialization
static ULONG deviceNum;
NTSTATUS DriverEntry( IN PDRIVER_OBJECT driverObject, 
                      IN PUNICODE_STRING registryPath );

// Block device
NTSTATUS EvtDeviceAdd( IN WDFDRIVER driver,
                       IN PWDFDEVICE_INIT deviceInit );

VOID EvtDeviceCleanup( IN WDFOBJECT deviceObject );

VOID EvtDeviceIoRead( IN WDFQUEUE queue, 
                      IN WDFREQUEST request,
                      IN size_t length );

VOID EvtDeviceIoWrite( IN WDFQUEUE queue, 
                       IN WDFREQUEST request,
                       IN size_t length );

VOID EvtDeviceIoDeviceControl( IN WDFQUEUE queue, 
                               IN WDFREQUEST request, 
                               IN size_t outputBufferLength,
                               IN size_t inputBufferLength,
                               IN ULONG ioctl );

#endif
