/**
 * Cleversafe open-source code header - Version 1.1 - December 1, 2006
 *
 * Cleversafe Dispersed Storage(TM) is software for secure, private and
 * reliable storage of the world's data using information dispersal.
 *
 * Copyright (C) 2005-2007 Cleversafe, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 *
 * Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
 * Chicago IL 60616
 * email licensing@cleversafe.org
 *
 * Author: Greg Dhuse <gdhuse@cleversafe.com>
 *
 */
#ifndef DSDBUS_WIN_H
#define DSDBUS_WIN_H

#include "dsd_win_common.h"

#define DSDBUS_TAG                     "dsdbus: "
#define DSDBUS_DEVICE_NAME             "\\Device\\" DSD_BUS_DEVICE_NAME

typedef struct _DSDBUS_CHILD_ID
{
   // Mandatory WDF header
   WDF_CHILD_IDENTIFICATION_DESCRIPTION_HEADER  header;  

   uint64_t numBlocks;  // Number of blocks on the device
   uint16_t blockSize;  // Size of a block in bytes
   
   int socket;          // Open socket for daemon communication

} DSDBUS_CHILD_ID, *PDSDBUS_CHILD_ID;


// Driver initialization
NTSTATUS DriverEntry( IN PDRIVER_OBJECT driverObject, 
                      IN PUNICODE_STRING registryPath );

// Bus
NTSTATUS Bus_EvtDeviceAdd( IN WDFDRIVER driver,
                           IN PWDFDEVICE_INIT deviceInit );

NTSTATUS Bus_PlugInDevice( IN WDFDEVICE device, 
                           IN uint64_t numBlocks, 
                           IN uint16_t blockSize, 
                           IN int socket );

NTSTATUS Bus_EvtChildListCreateDevice( 
   IN WDFCHILDLIST childList, 
   IN OUT PWDF_CHILD_IDENTIFICATION_DESCRIPTION_HEADER ident,
   IN OUT PWDFDEVICE_INIT childInit );

VOID Bus_EvtDeviceIoDeviceControl( IN WDFQUEUE queue, 
                                   IN WDFREQUEST request, 
                                   IN size_t outputBufferLength,
                                   IN size_t inputBufferLength,
                                   IN ULONG ioctl );

#endif
