//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Jan 4, 2008
//---------------------

package org.cleversafe.layer.access.cli;
import java.io.IOException;

import javax.management.InstanceNotFoundException;

import org.cleversafe.layer.access.GridAccessConnector;
import org.cleversafe.layer.access.jmx.GridAccessMBean;
import org.cleversafe.layer.access.jmx.VaultStatusMBean;

// TODO: Describe class or interface
public class CreateTarget extends AbstractCLI
{  
   private static final String COMMAND_NAME = "dsnet-create-target";
   
   private static final String VAULT_NAME_OPTION = "vault_name";
   private static final String TARGET_IQN_OPTION = "target_iqn";
   
   private static final String SERVICE_TYPE = "iscsi";
   
   ////////////////////////////////////////////////////////////////////////////////////////////////
   
   private final String vaultName;
   private final String targetIqn;
   
   public CreateTarget(String[] args) throws ExitStatusException
   {
      super(CreateTarget.class,
            COMMAND_NAME,
            "create_target_client.jsap",
            "Makes a dsNet vault available as an iSCSI target",
            args);
      this.vaultName = this.getJSAPResult().getString(VAULT_NAME_OPTION);
      this.targetIqn = this.getJSAPResult().getString(TARGET_IQN_OPTION);
   }
   
   public CreateTarget(
         String jmxHost,
         int jmxPort,
         String vaultName,
         String targetIqn)
   {
      super(COMMAND_NAME, jmxHost, jmxPort);
      this.vaultName = vaultName;
      this.targetIqn = targetIqn;
   }
   

   public void run()
   {
      GridAccessConnector connector = this.getGridAccessConnector();
      
      try
      {
         connector.connect();  
         
         VaultStatusMBean vs = connector.getVaultStatusMBean();
         GridAccessMBean ga = connector.getGridAccessMBean();
         
         
         // Get information for status output
         
         String vaultIdentifier = vs.getVaultIdentifier(vaultName);
         
         String[] settings = ga.getServiceInterfaceSettings(SERVICE_TYPE);
         if (settings.length < 5)
         {
            throw new ExitStatusException(
                  "Invalid portal settings returned from access server", AbstractCLI.IO_ERROR);
         }
         boolean running = Boolean.valueOf(settings[4]);
         
         
         // Create the service
         ga.createService(SERVICE_TYPE, this.targetIqn, vaultIdentifier);
         
         
         System.out.println("Successfully created iSCSI target using dsNet vault.");
         System.out.println("Target name:      " + this.targetIqn);
         System.out.println("Vault name:       " + this.vaultName);
         System.out.println("Vault identifier: " + vaultIdentifier);
         System.out.println((running ? "Target is now running." : "Target is not yet running."));
      }
      catch (InstanceNotFoundException e)
      {
         throw new ExitStatusException("Error connecting to access server", IO_ERROR, e);
      }
      catch (Exception e)
      {
         throw new ExitStatusException("Error creating target on access server", UNKNOWN_ERROR, e);
      }
      finally
      {
         try
         {
            if (connector != null)
            {
               connector.close();
            }
         }
         catch (IOException e) {}
      }
   }

   public static void main(String[] args)
   {
      try
      {
         CreateTarget client = new CreateTarget(args);
         client.finish();
      }
      catch (ExitStatusException e)
      {
         System.exit(e.getStatus());
      }
   }
   
}


