//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Jan 5, 2008
//---------------------

package org.cleversafe.layer.access.cli;
import java.io.IOException;

import javax.management.InstanceNotFoundException;

import org.cleversafe.layer.access.GridAccessConnector;
import org.cleversafe.layer.access.jmx.GridAccessMBean;

// TODO: Describe class or interface
public class DeleteTarget extends AbstractCLI
{
   private static final String COMMAND_NAME = "dsnet-delete-target";
   
   private static final String TARGET_IQN_OPTION = "target_iqn";

   private static final String SERVICE_TYPE = "iscsi";
   
   ////////////////////////////////////////////////////////////////////////////////////////////////
   
   private final String targetIqn;
   
   public DeleteTarget(String[] args) throws ExitStatusException
   {
      super(DeleteTarget.class,
            COMMAND_NAME,
            "delete_target_client.jsap",
            "Removes an iSCSI Target without removing the underlying dsNet Vault",
            args);
      this.targetIqn = getJSAPResult().getString(TARGET_IQN_OPTION);
   }
   
   public DeleteTarget(String jmxHost, int jmxPort, String targetIqn)
   {
      super(COMMAND_NAME, jmxHost, jmxPort);
      this.targetIqn = targetIqn;
   }
   
   public void run()
   {
      GridAccessConnector connector = this.getGridAccessConnector();
      
      try
      {
         connector.connect();
         
         GridAccessMBean ga = connector.getGridAccessMBean();
         
         // Get settings as array of (type, serviceName, vaultName, vaultIdentifier) arrays
         String[] service = ga.getServiceSettings(SERVICE_TYPE, this.targetIqn);
         
         ga.deleteService(SERVICE_TYPE, this.targetIqn);
         
         System.out.println("Successfully deleted an iSCSI target.");
         System.out.println("Target name:      " + service[1]);
         System.out.println("Vault name:       " + service[2]);
         System.out.println("Vault identifier: " + service[3]);
      }
      catch (InstanceNotFoundException e)
      {
         throw new ExitStatusException("Error connecting to access server", IO_ERROR, e);
      }
      catch (Exception e)
      {
         throw new ExitStatusException("Error deleting target on access server", UNKNOWN_ERROR, e);
      }
      finally
      {
         try
         {
            if (connector != null)
            {
               connector.close();
            }
         }
         catch (IOException e) {}
      }
   }

   public static void main(String[] args)
   {
      try
      {
         DeleteTarget client = new DeleteTarget(args);
         client.finish();
      }
      catch (ExitStatusException e)
      {
         System.exit(e.getStatus());
      }
   }

}


