//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Dec 11, 2007
//---------------------

package org.cleversafe.layer.access.managers.state;
import java.util.List;
import java.util.UUID;

import org.cleversafe.layer.access.Service;
import org.cleversafe.layer.access.exceptions.InvalidVaultLoadException;
import org.cleversafe.layer.access.exceptions.InvalidVaultTypeException;
import org.cleversafe.layer.access.exceptions.ServiceConfigurationException;
import org.cleversafe.layer.access.managers.LocalFileGridAccessManager;
import org.cleversafe.vault.Vault;

/**
 * Persistence wrapper for {@link Service} objects returned from the
 * {@link LocalFileGridAccessManager} implementation.
 */
public class LocalFileServiceWrapper implements Service
{
   private ServiceState state;
   private Service service;
   
   
   public LocalFileServiceWrapper(ServiceState state, Service service)
   {
      this.state = state;
      this.service = service;
   }

   public String getName()
   {
      return this.state.getName();
   }

   public List<String> getSupportedVaultTypes()
   {
      return this.service.getSupportedVaultTypes();
   }

   public String getType()
   {
      return this.state.getType();
   }

   public UUID getVaultIdentifier()
   {
      return this.state.getVault().getIdentifier();
   }

   public Service load(String name, Vault vault) throws InvalidVaultTypeException,
         ServiceConfigurationException, InvalidVaultLoadException
   {
      return this.service.load(this.state.getName(), vault);
   }
   
   public ServiceState getState()
   {
      return this.state;
   }

}


