//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Dec 6, 2007
//---------------------

package org.cleversafe.layer.access.managers.state;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Version;

import org.cleversafe.layer.iscsi.ISCSIPortal;
import org.cleversafe.vault.managers.state.VaultState;

@Entity
@Table(name = "SERVICE")
public class ServiceState
{
   public static final String ISCSI_SERVICE = ISCSIPortal.ISCSI_SERVICE;
   
   @Id @GeneratedValue
   @Column(name = "SERVICE_ID", nullable = false)
   private int id;
   
   @Version
   @Column(name = "OBJ_VERSION")
   private int version;
   
   @Column(name = "SERVICE_TYPE")
   private String type;
   
   @Column(name = "SERVICE_NAME", unique = true)
   private String name;
   
   @ManyToOne(cascade = CascadeType.PERSIST)
   @JoinColumn(name = "SERVICE_VAULT")
   private VaultState vault;
   
   @ManyToMany(mappedBy = "services")
   private Set<ServiceInterfaceState> serviceInterfaces = new HashSet<ServiceInterfaceState>();

   
   

   @Override
   public int hashCode()
   {
      final int prime = 31;
      int result = 1;
      result = prime * result + ((name == null) ? 0 : name.hashCode());
      result = prime * result + ((type == null) ? 0 : type.hashCode());
      return result;
   }

   @Override
   public boolean equals(Object obj)
   {
      // Compares business keys (type, name)
      if (this == obj)
         return true;
      if (obj == null)
         return false;
      if (getClass() != obj.getClass())
         return false;
      final ServiceState other = (ServiceState) obj;
      if (name == null)
      {
         if (other.getName() != null)
            return false;
      }
      else if (!name.equals(other.getName()))
         return false;
      if (type == null)
      {
         if (other.getType() != null)
            return false;
      }
      else if (!type.equals(other.getType()))
         return false;
      return true;
   }

   public int getId()
   {
      return id;
   }

   public int getVersion()
   {
      return version;
   }

   public String getType()
   {
      return type;
   }

   public void setType(String type)
   {
      this.type = type;
   }

   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   public VaultState getVault()
   {
      return vault;
   }

   public void setVault(VaultState vault)
   {
      this.vault = vault;
   }

   public Set<ServiceInterfaceState> getServiceInterfaces()
   {
      return Collections.unmodifiableSet(this.serviceInterfaces);
   }
   
   /**
    * Allows proper implementation of {@link Set#add(Object)} for the set returned from
    * {@link ServiceInterfaceState#getServices()}
    */
   protected Set<ServiceInterfaceState> getModifiableServiceInterfaceSet()
   {
      return this.serviceInterfaces;
   }
   

   
   
   
}


