//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Dec 7, 2007
//---------------------

package org.cleversafe.layer.access.test;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

import org.cleversafe.layer.access.Service;
import org.cleversafe.layer.access.exceptions.InvalidVaultTypeException;
import org.cleversafe.layer.access.exceptions.ServiceConfigurationException;
import org.cleversafe.vault.Vault;


public class TestService implements Service
{
   private String name;
   private String type;
   private Vault vault;
   private boolean failLoad;
   
   public TestService()
   {
      this(null);
   }
   
   public TestService(String name)
   {
      this(name, "test", false);
   }
   
   public TestService(String name, String type, boolean failLoad)
   {
      this.name = name;
      this.type = type;
      this.failLoad = failLoad;
   }

   public String getName()
   {
      return this.name;
   }

   public List<String> getSupportedVaultTypes()
   {
      return Arrays.asList(new String[] {"test", "block"});
   }

   public String getType()
   {
      return this.type;
   }

   public Service load(String name, Vault vault) throws InvalidVaultTypeException,
         ServiceConfigurationException
   {
      if (this.failLoad)
         throw new ServiceConfigurationException("configured failure");
      if (!this.getSupportedVaultTypes().contains(vault.getType()))
         throw new InvalidVaultTypeException("unsupported vault type: " + vault.getType());
      this.name = name;
      this.vault = vault;
      return this;
   }

   public UUID getVaultIdentifier()
   {
      return this.vault.getVaultIdentifier();
   }
   
   
   
}


