//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Dec 7, 2007
//---------------------

package org.cleversafe.layer.access.test;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.cleversafe.layer.access.ServiceInterface;
import org.cleversafe.layer.access.exceptions.AccessStateModificationException;
import org.cleversafe.layer.access.exceptions.ServiceConfigurationException;
import org.cleversafe.layer.access.exceptions.ServiceInterfaceStartStopException;
import org.cleversafe.layer.access.exceptions.ServiceNotFoundException;
import org.cleversafe.layer.access.exceptions.ServiceStartStopException;
import org.cleversafe.layer.access.exceptions.ServiceStillRunningException;

public class TestServiceInterface implements ServiceInterface<TestService>
{
   private String type;
   private boolean failLoad;
   private boolean running;
   private Map<String,TestService> services = new HashMap<String,TestService>();
   private String host;
   private int port;
   private boolean autostart;
   
   public TestServiceInterface()
   {
      this("test", false);
   }
   
   public TestServiceInterface(String type)
   {
      this(type, false);
   }

   public TestServiceInterface(String type, boolean failLoad)
   {
      super();
      this.type = type;
      this.failLoad = failLoad;
   }

   public void add(TestService service) throws AccessStateModificationException
   {
      this.services.put(service.getName(), service);
   }
   
   

   public TestService remove(TestService service) throws ServiceStillRunningException,
         AccessStateModificationException, ServiceNotFoundException
   {
      return this.services.remove(service.getName());
   }

   public TestService getService(String serviceName) throws ServiceNotFoundException
   {
      TestService service = this.services.get(serviceName);
      if ( service == null )
         throw new ServiceNotFoundException("service not found: " + serviceName);
      return service;
   }

   public String[] getServiceNames()
   {
      return this.services.values().toArray(new String[] {});
   }

   public List<TestService> getServices()
   {
      List<TestService> services = new ArrayList<TestService>();
      services.addAll(this.services.values());
      return Collections.unmodifiableList(services);
   }

   public String getType()
   {
      return this.type;
   }

   public boolean isRunning()
   {
      return this.running;
   }

   public ServiceInterface<TestService> load(String host, int port)
         throws ServiceConfigurationException
   {
      if (this.failLoad)
         throw new ServiceConfigurationException("configured failure");
      this.host = host;
      this.port = port;
      return this;
   }

   public TestService remove(String serviceName) throws ServiceStillRunningException,
         AccessStateModificationException, ServiceNotFoundException
   {
      TestService service = this.services.remove(serviceName);
      if (service == null)
         throw new ServiceNotFoundException("no such service: " + serviceName);
      return service;
   }

   public void start() throws ServiceInterfaceStartStopException, ServiceStartStopException
   {
      this.running = true;
   }

   public void stop() throws ServiceInterfaceStartStopException, ServiceStartStopException
   {
      this.running = false;
   }

   public String getHost()
   {
      return host;
   }

   public int getPort()
   {
      return port;
   }

   public boolean isStartsAutomatically()
   {
      return this.autostart;
   }

   public ServiceInterface<TestService> setHost(String host)
         throws AccessStateModificationException
   {
      this.host = host;
      return (ServiceInterface<TestService>)this;
   }

   public ServiceInterface<TestService> setPort(int port)
         throws AccessStateModificationException
   {
      this.port = port;
      return (ServiceInterface<TestService>)this;
   }

   public ServiceInterface<TestService> setStartsAutomatically(boolean autostart)
         throws AccessStateModificationException
   {
      this.autostart = true;
      return (ServiceInterface<TestService>)this;
   }
   
   
   
   
}


