//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: gdhuse
//
// Date: May 4, 2007
//---------------------

package org.cleversafe.layer.block.dsd.message;
//import org.apache.log4j.Logger;
import java.io.*;

import org.cleversafe.layer.block.dsd.message.DeviceMessage;


/**
 * Request from the device to read a contiguous sequence of
 * blocks from the grid.  
 */
public class ReadBlocksDeviceMessage extends DeviceMessage
{
   public static final int MESSAGE_TYPE = 0xA2;
   protected static final int MESSAGE_LENGTH = 13; //16;
   
   //private static Logger _logger = Logger
   //      .getLogger(ReadBlocksDeviceMessage.class);
   
   // Tag used by the device driver to associate a request with a response
   protected int requestTag;
   
   // First block to read
   protected long firstBlock;
   
   // Number of contiguous blocks to read, starting with firstBlock
   protected int numBlocks;
   
   /**
    * Construct an empty message
    */
   public ReadBlocksDeviceMessage()
   {
      this.requestTag = -1;
      this.firstBlock = -1;
      this.numBlocks  = -1;
   }
   
   /**
    * Construct a fully-formed message
    * @param requestTag Device request tag
    * @param firstBlock First block to be read
    * @param numBlocks Number of blocks to read
    * @throws IOException
    */
   public ReadBlocksDeviceMessage( 
         int requestTag, 
         long firstBlock, 
         int numBlocks ) throws IOException
   {
      this.requestTag = requestTag;
      this.firstBlock = firstBlock;
      this.numBlocks  = numBlocks;
   }
   
   public void deserialize( DataInputStream in ) throws IOException
   {
      Header header = new Header();
      header.deserialize( in, false );
      
      this.requestTag = in.readInt();
      this.firstBlock = in.readLong();
      this.numBlocks = in.readUnsignedByte();
      //in.skip( 3 );  // Align to 4-byte boundary
   }

   public void serialize( DataOutputStream out ) throws IOException
   {
      Header header = new Header( MESSAGE_TYPE, MESSAGE_LENGTH );
      header.serialize( out );
      
      out.writeInt( this.requestTag );
      out.writeLong( this.firstBlock );
      
      out.writeByte( this.numBlocks );
      /*for( int i = 0; i < 3; ++i )
      {
         out.writeByte( 0x0 ); // Align to 4-byte boundary
      }*/
   }

   public long getFirstBlock()
   {
      return firstBlock;
   }

   public void setFirstBlock(long firstBlock)
   {
      this.firstBlock = firstBlock;
   }

   public int getNumBlocks()
   {
      return numBlocks;
   }

   public void setNumBlocks(int numBlocks)
   {
      this.numBlocks = numBlocks;
   }

   public int getRequestTag()
   {
      return requestTag;
   }

   public void setRequestTag(int requestTag)
   {
      this.requestTag = requestTag;
   }
}


