//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: gdhuse
//
// Date: May 6, 2007
//---------------------

package org.cleversafe.layer.block.dsd.message;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

//import org.apache.log4j.Logger;

/**
 * Response to a WriteBlocksDeviceMessage
 */
public class WriteBlocksResponseDeviceMessage extends DeviceMessage
{
   // Protocol message type
   public static final int MESSAGE_TYPE = 0xA5;
   protected static final int MESSAGE_LENGTH = 5;
   
   //private static Logger _logger = Logger
   //      .getLogger(WriteBlocksResponseDeviceMessage.class);
   
   // Tag used by the device driver to associate a request with a response
   int requestTag;
   
   // Request status - 0 for success, < 0 for error
   int status;
   
   /**
    * Construct a fully-formed message
    * @param requestTag Device request tag
    * @param status Error status
    */
   public WriteBlocksResponseDeviceMessage( int requestTag, int status )
   {
      this.requestTag = requestTag;
      this.status = status;
   }

   @Override
   public void deserialize(DataInputStream in) throws IOException
   {
      Header header = new Header();
      header.deserialize( in, false );
      
      this.requestTag = in.readInt();
      this.status = in.readUnsignedByte();
   }

   @Override
   public void serialize(DataOutputStream out) throws IOException
   {
      Header header = new Header( MESSAGE_TYPE, MESSAGE_LENGTH );
      header.serialize( out );
      
      out.writeInt( this.requestTag );
      out.writeByte( this.status );
   }

   public int getRequestTag()
   {
      return requestTag;
   }

   public void setRequestTag(int requestTag)
   {
      this.requestTag = requestTag;
   }

   public int getStatus()
   {
      return status;
   }

   public void setStatus(int status)
   {
      this.status = status;
   }
}


