//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: bcilfone
//
// Date: Mar 19, 2008
//---------------------

package org.cleversafe.layer.iscsi.authentication;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

import org.apache.log4j.Logger;

public class PropertiesSourceOfSecrets implements SourceOfSecrets
{
   private Properties properties;

   private static Logger _logger = Logger.getLogger(PropertiesSourceOfSecrets.class);

   /**
    * Construct a SourceOfSecrets based on a standard java properties file with
    * username=secret key value pairs
    * 
    * @param filename
    * @throws IOException
    */
   public PropertiesSourceOfSecrets(String filename) throws IOException
   {
      if (filename == null)
      {
         throw new IllegalArgumentException("Cannot pass null filename to PropertiesSourceOfSecrets constructor");
      }

      _logger.info("Loading secrets from file: " + filename);

      this.properties = new Properties();
      this.properties.load(new FileInputStream(filename));
   }

   /**
    * Get the secret for the given username
    */
   public byte[] getSecret(String name)
   {
      String secret = this.properties.getProperty(name);

      if (secret == null)
      {
         //  If one is not found for the username, look for a special secret called defaultSecret
         secret = this.properties.getProperty("defaultSecret");

         if (secret == null)
         {
            return null;
         }
      }

      return secret.getBytes();
   }

}
