//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: jquigley
//
// Date: Oct 22, 2007
//---------------------

package org.cleversafe.layer.target.tasks;

import org.cleversafe.layer.block.BlockDeviceController;
import org.cleversafe.util.rangelock.RangeReadWriteLock;
import org.jscsi.scsi.protocol.Command;
import org.jscsi.scsi.protocol.inquiry.InquiryDataRegistry;
import org.jscsi.scsi.protocol.mode.ModePageRegistry;
import org.jscsi.scsi.tasks.AbstractTask;
import org.jscsi.scsi.tasks.Task;
import org.jscsi.scsi.transport.TargetTransportPort;

public abstract class GridTask extends AbstractTask
{
   // BlockDeviceController for grid I/O
   private BlockDeviceController blockDeviceController;

   private RangeReadWriteLock rangeReadWriteLock;

   /**
    * Creates new GridTask with a particular name.
    * 
    * @param name The name of this task.
    */
   public GridTask(final String name)
   {
      super(name);
   }

   /**
    * Creates a new GridTask specifying all configurable components.
    * 
    * @param name The name of this task
    * @param targetPort The transport interface used for ISCSI-SCSI data I/O
    * @param command The SCSI command being wrapped
    * @param modePageRegistry The registry of ModePages this task should use
    * @param inquiryDataRegistry The registry of InquiryData this task should use
    * @param blockDeviceController The supervisor for grid-based I/O
    */
   public GridTask(
         final String name,
         final TargetTransportPort targetPort,
         final Command command,
         final ModePageRegistry modePageRegistry,
         final InquiryDataRegistry inquiryDataRegistry,
         final BlockDeviceController blockDeviceController,
         final RangeReadWriteLock rangeReadWriteLock)
   {
      super(name, targetPort, command, modePageRegistry, inquiryDataRegistry);
      this.blockDeviceController = blockDeviceController;
      this.rangeReadWriteLock = rangeReadWriteLock;
   }

   /**
    * Creates a new GridTask specifying all configurable components.
    * 
    * @param targetPort
    * @param command
    * @param modePageRegistry
    * @param inquiryDataRegistry
    * @param blockDeviceController
    * @return
    */
   protected final Task load(
         final TargetTransportPort targetPort,
         final Command command,
         final ModePageRegistry modePageRegistry,
         final InquiryDataRegistry inquiryDataRegistry,
         final BlockDeviceController blockDeviceController,
         final RangeReadWriteLock rangeReadWriteLock)
   {
      super.load(targetPort, command, modePageRegistry, inquiryDataRegistry);
      this.blockDeviceController = blockDeviceController;
      this.rangeReadWriteLock = rangeReadWriteLock;
      return this;
   }

   /**
    * Acquires the BlockDeviceController associated with this task, to be used for grid I/O.
    * 
    * @return The associated BlockDeviceController
    */
   public BlockDeviceController getBlockDeviceController()
   {
      return this.blockDeviceController;
   }

   protected RangeReadWriteLock getRangeReadWriteLock()
   {
      return this.rangeReadWriteLock;
   }
}
