//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Nov 16, 2007
//---------------------

package org.cleversafe.layer.target.tasks;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

import org.apache.log4j.Logger;
import org.jscsi.scsi.tasks.Status;
import org.jscsi.scsi.protocol.cdb.ReadCapacity10;
import org.jscsi.scsi.protocol.cdb.ReadCapacity16;
import org.jscsi.scsi.protocol.sense.exceptions.SenseException;

/**
 * @author John Quigley <jquigley@cleversafe.com>
 * @version $Id$
 */
public class ReadCapacityGridTask extends GridTask
{
   private static Logger _logger = Logger.getLogger(ReadCapacityGridTask.class);

   /**
    * Creates a new ReadCapacityGridTask.
    */
   public ReadCapacityGridTask()
   {
      super("ReadCapacityGridTask");
   }
   
   /**
    * Executes this particular task from within the TaskManager.
    * 
    * @throws InterruptedException
    * @throws SenseException
    */
   @Override
   protected void execute() throws InterruptedException, SenseException
   {
      int blockSize = getBlockDeviceController().getBlockSize();
      long lba = getBlockDeviceController().getNumBlocks() - 1;

      ByteArrayOutputStream bs = new ByteArrayOutputStream();
      DataOutputStream out = new DataOutputStream(bs);

      try
      {
         if (getCommand().getCommandDescriptorBlock() instanceof ReadCapacity10)
         {
            if (lba >= 0xFFFFFFFFL)
            {
               out.writeInt(-1);
            }
            else
            {
               out.writeInt((int) lba);
            }
            out.writeInt(blockSize);
         }
         else if (getCommand().getCommandDescriptorBlock() instanceof ReadCapacity16)
         {
            out.writeLong(lba);
            out.writeInt(blockSize);

            out.writeInt(0);
            out.writeLong(0);
            out.writeLong(0);
         }
         else
         {
            _logger.debug("ReadCapacityGridTask raised an exception: invalid cdb passed");
            throw new RuntimeException("Invalid CDB passed in ReadCapacityGridTask");
         }
      }
      catch (IOException e)
      {
         _logger.debug("ReadCapacityGridTask raised an exception: unable to encode parameter data");
         throw new RuntimeException("unable to encode READ CAPACITY parameter data");
      }

      this.writeData(ByteBuffer.wrap(bs.toByteArray()));
      this.writeResponse(Status.GOOD, null);
   }

   /**
    * Gets the string representation of this class.
    * 
    * @return The string representation
    */
   public String toString()
   {
      return "<ReadCapacityGridTask>";
   }
}
