/**
 * 
 */

package org.cleversafe.block;

import java.io.*;

import org.apache.commons.math.random.RandomData;
import org.apache.commons.math.random.RandomDataImpl;

//import javax.crypto.Cipher;

import java.security.SecureRandom;
//import java.security.cert.*;
//import java.util.Enumeration;
import java.util.Properties;

/**
 * @author Srini Palthepu
 *
 */
public class FileGenerator {
	
	private static final String propFile = "filegen.ini";
//	private static String seed;
	private static String distribution;
	private static String dir, filePrefix;
	private static int numFiles, sampleSize;
	private static long minSize, maxSize, numSamples;
	private static long min, max;

	private static void generateFile(int i, long numSamples)
	{
		int j;
		String fileName;

		fileName = dir + File.separator + filePrefix + Integer.toString(i);
		File f = new File(fileName);
		// Cipher c = null;
		SecureRandom secureRandom = null;
		try {
			//Initialize a secure random number generator
			secureRandom = SecureRandom.getInstance("SHA1PRNG");
    
			//	c = Cipher.getInstance("DES/CBC/PKCS5Padding");
		} catch (Exception e) {
			System.out.println(e);
			System.exit(1);
		}

		// open the file
		FileOutputStream fout =  null;
		try {
			fout = new FileOutputStream(f); 
		} catch ( FileNotFoundException e){
			System.out.println("File Not Found" + f);
		}
		
		byte [] data = new byte[sampleSize];
		for (j=0; j<numSamples; j++){
	
			try {
				// new_data = c.doFinal(data);
			    //  Calling nextBytes method to generate Random Bytes
		        secureRandom.nextBytes(data); 

			} catch (Exception e) {
				System.out.println("Cipher exception");
				System.exit(2);
			}
			// write to file
			try {
				fout.write(data);
			} catch ( IOException e) {
				System.out.println("IOException");
			}
		}
		// close the file.
		try {
			fout.close();

		} catch ( IOException e) {
			System.out.println("IOException");
		}
	}
	
	private static void loadProperties(String file) {

		// seed = "myseed";
		distribution = "uniform";
		filePrefix = "test";
		numFiles = 1000;
		sampleSize = 1024;
		minSize = sampleSize;
		maxSize = 1  * 1024 * 1024; //10 * 1024*1024*1024; //10GB
		min = minSize / sampleSize;
		max = maxSize / sampleSize;
		dir = "C:" + File.separator + "tempdir";
		
		//create and load default properties
		Properties props = new Properties();
		FileInputStream in = null;
		if (file == null){
			file = "C:" + File.separator + propFile;
		}
		try {
			in = new FileInputStream(file);
		} catch (FileNotFoundException e) {
			//
			System.out.println("Properties file " + file + " does not exists. Using hardcoded values.");
			return;
		}
		System.out.println("Loading properties from " + file); 
		try {
			props.load(in);
			in.close();
		} catch (IOException e){
			System.out.println("Problems loading properties file. Using hardcoded values.");
			return;
		}
		
		// read properties now and set local variables.
		if (props.containsKey("NUM_FILES")){
			String numf = props.getProperty("NUM_FILES");
			numFiles = Integer.parseInt(numf);
		}
		if (props.containsKey("MAX_SIZE")){
			String numf = props.getProperty("MAX_SIZE");
			maxSize = Integer.parseInt(numf);
		}
		if (props.containsKey("SAMPLE_SIZE")){
			String numf = props.getProperty("SAMPLE_SIZE");
			sampleSize = Integer.parseInt(numf);
		}
		if (props.containsKey("OUTPUT_DIR")){
			dir = props.getProperty("OUTPUT_DIR");
		}
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {

	
		if (args.length < 1) {
			loadProperties(null);
		} else {
			loadProperties(args[0]);
		}
		
		RandomData randomData = new RandomDataImpl(); 
		System.out.println("Generating data files: numfiles=" + numFiles + " sampleSize=" + 

sampleSize + " maxSize=" + maxSize);
		File dirF = new File(dir);
		if (!dirF.exists()) {
			try {
				// Create one directory
				boolean success = dirF.mkdirs();
				if (success) {
					System.out.println("Directory: " + dir + " created");
				}
			} catch (Exception e){//Catch exception if any
				System.err.println("Error: " + e.getMessage());
			}
		}
		
		for (int i = 0; i < numFiles; i++) {

			if ( distribution == "uniform"){
				numSamples = randomData.nextLong(min, max);
			} else {
				System.out.println("Only uniform distribution is supported");
			}
		    generateFile(i, numSamples);
		}
		System.out.println("Done.");
	}
}