#include "parameters.h"
#include <jni.h>
#include "org_cleversafe_ida_cauchy_NativeIF.h"
#include <sys/time.h>
#include <stdio.h>

#ifdef WIN32
#include <winsock2.h>
#else
#include <netinet/in.h>
#endif

/**
 * A nibble->char mapping for printing out bytes.
 */
unsigned char digits[] = {
  '0' , '1' , '2' , '3' , '4' , '5' , '6' , '7' , '8' , '9' ,
  'a' , 'b' , 'c' , 'd' , 'e' , 'f'
};

/**
 * Produce a <code>String</code> representation for the specified array of
 * <code>byte</code>s.  Print each <code>byte</code> as two hexadecimal
 * digits.
 *
 * @param data	The array to print
 * @param offset 	the start offset in <code>data</code>
 * @param length	the number of <code>byte</code>s to print
 /
void print_bytes (jbyte* data, int offset, int length)
{
  unsigned char buf[2*length+1]; 
  int low_mask = 0x0f;
  int high_mask = 0xf0;
  int buf_pos = 0;
  int i;
  jbyte b;
  buf[2*length] = '\0';
  
  for (i=offset; i < (offset+length); ++i) {
    b = data[i];
    buf[buf_pos++] = digits[(high_mask & b) >> 4];
    buf[buf_pos++] = digits[(low_mask & b)];
  }
  printf("%s", buf);
}
*/

/**
 * Produce a <code>String</code> representation for the specified array of
 * <code>byte</code>s.  Print each <code>byte</code> as two hexadecimal
 * digits.
 *
 * @param data	The array to print
 * @param offset 	the start offset in <code>data</code>
 * @param length	the number of <code>byte</code>s to print
 */
char* print_bytes (jbyte* data, int offset, int length, unsigned char* buf)
{
  int low_mask = 0x0f;
  int high_mask = 0xf0;
  int buf_pos = 0;
  int i;
  jbyte b;
  buf[2*length] = '\0';
  
  for (i=offset; i < (offset+length); ++i) {
    b = data[i];
    buf[buf_pos++] = digits[(high_mask & b) >> 4];
    buf[buf_pos++] = digits[(low_mask & b)];
  }
  return buf;
}

struct timeval encode(UNSIGNED* packets, UNSIGNED* message, int Mpackets, 
		      int Rpackets, int Nsegs, int Lfield)
{
  int i,j,k,l,m, ind_seg,col_eqn,row_eqn,ind_eqn;
  int row, col, ExpFE;
  struct timeval start_time, end_time;
  struct timeval total_time;

  int TableLength = 1<<Lfield;
  int SMultField = (1<<Lfield) - 1;
  int Plen = Nsegs * Lfield;
  int Plentot = Plen + 1;

  int Npackets = Mpackets + Rpackets;
  int Mseglen = Mpackets * Lfield;
  int Mlen = Plen * Mpackets;
  int Elen = Plen * (Mpackets + Rpackets);

  if(available==0)
    Init_Field(Lfield, TableLength, SMultField);

  gettimeofday(&start_time,0);

  /* Set the identifier in all the packets to be sent */
  for(i=0; i < Npackets; i++)
    packets[i*Plentot] = i;

  /* Copy the message into the first Mpackets packets */
  k = 0;
  j = 0;
  for(i=0; i < Mpackets; i++)
  {
    k ++;
    for(ind_eqn=0; ind_eqn < Lfield; ind_eqn++)
    {
      for(ind_seg =0; ind_seg  < Nsegs; ind_seg ++)
      {
	packets[k] = message[j];
        j++;
        k++;
      }
    }
  }

  /* Fill in values for remaining Rpackets packets */
  for(row=0; row < Rpackets; row++)
  {
    /* Compute values of equations applied to message 
       and fill into packet(row+Mpackets).  */

    /* First, zero out contents relevant portions of packet */
    j = (row+Mpackets)*Plentot;
    for(i =1; i  < Plentot; i ++) 
      packets[j+i] = 0;

    /* Second, fill in contents relevant portions of packet */
    for (col=0; col < Mpackets; col++)
    {
      m = col*Lfield * Nsegs;
      ExpFE = (SMultField - FEtoExp[row^col^COLBIT]) % SMultField;
      for (row_eqn=0; row_eqn < Lfield; row_eqn++)
      {
	k = row_eqn * Nsegs;
	for (col_eqn=0; col_eqn < Lfield; col_eqn++)
	{
	  if (ExptoFE[ExpFE+row_eqn] & BIT[col_eqn])
	  {
	    l = col_eqn * Nsegs + m;
	    for (ind_seg=0; ind_seg < Nsegs; ind_seg++)
	    {
	      packets[j+1+ind_seg+k] ^= message[ind_seg+l];
	    }
	  }
	}
      }
    }
  }

  gettimeofday(&end_time,0);

  total_time.tv_sec = (end_time.tv_sec-start_time.tv_sec);
  total_time.tv_usec = (end_time.tv_usec-start_time.tv_usec);

#ifdef PRINT2  
  printf("\n %f",
	 (float)((total_time.tv_sec)*1000.0)+
	 (float)(((total_time.tv_usec)/1000.0))); 
#endif

#ifdef PRINT
  printf ("\n------------------------------------------------");
  printf ("\n encode: number of seconds is %f",
	  (float)(total_time.tv_sec)+
	  (float)(total_time.tv_usec)/1000000.0); 
  printf ("\n------------------------------------------------\n\n");
  fflush(stdout);
#endif

  return total_time;
}

struct timeval decode(UNSIGNED* rec_message, UNSIGNED* rec_packets, 
		      int Nrec, int Mpackets, int Rpackets, int Nsegs, 
		      int Lfield)
{
  int i,j,k,l,m, index, seg_ind;
  int col_ind, row_ind, col_eqn, row_eqn;
  int Nfirstrec, Nextra;
  UNSIGNED *Rec_index;
  UNSIGNED *Col_Ind, *Row_Ind, ExpFE;
  UNSIGNED  *M;
  UNSIGNED *C, *D, *E, *F;
  struct timeval start_time, end_time;
  struct timeval total_time;

  int TableLength = 1<<Lfield;
  int SMultField = (1<<Lfield) - 1;
  int Plen = Nsegs * Lfield;
  int Plentot = Plen + 1;

  int Npackets = Mpackets + Rpackets;
  int Mseglen = Mpackets * Lfield;
  int Mlen = Plen * Mpackets;
  int Elen = Plen * (Mpackets + Rpackets);

  if(available==0)
    Init_Field(Lfield, TableLength, SMultField);

  Rec_index = (UNSIGNED*) calloc(Mpackets, sizeof(UNSIGNED));
  if (!(Rec_index)) {printf("\ndecode: Rec_index malloc failed\n"); exit(434); }

  Col_Ind = (UNSIGNED*) calloc(Mpackets, sizeof(UNSIGNED));
  if (!(Col_Ind)) {printf("\ndecode: Col_Ind malloc failed\n"); exit(434); }

  Row_Ind = (UNSIGNED*) calloc(Rpackets, sizeof(UNSIGNED));
  if (!(Row_Ind)) {printf("\ndecode: Row_Ind malloc failed\n"); exit(434); }

  C = (UNSIGNED *) calloc(Rpackets, sizeof(UNSIGNED));
  if (!(C)) {printf("\ndecode: C malloc failed\n"); exit(434); }

  D = (UNSIGNED *) calloc(Mpackets, sizeof(UNSIGNED));
  if (!(D)) {printf("\ndecode: D malloc failed\n"); exit(434); }

  E = (UNSIGNED *) calloc(Mpackets, sizeof(UNSIGNED));
  if (!(E)) {printf("\ndecode: E malloc failed\n"); exit(434); }

  F = (UNSIGNED *) calloc(Rpackets, sizeof(UNSIGNED));
  if (!(F)) {printf("\ndecode: F malloc failed\n"); exit(434); }

  M = (UNSIGNED *) calloc(Nsegs*Rpackets*Lfield, sizeof(UNSIGNED));
  if (!(M)) {printf("\ndecode: M malloc failed\n"); exit(434); }

  if (Nrec < Mpackets) 
    {
#ifdef PRINT
      printf("*** Need %d packets to recover message",Mpackets);
      printf(" but only %d packets received *** \n",Nrec);
#endif
      total_time.tv_sec = -1;
      total_time.tv_sec = -1;
      return total_time;
    }

  /* Initialize the received message */

  for(i=0; i < Mlen; i++) 
    rec_message[i] = 0;

  /* Move information from packets into received message.
     Fill in parts of received message that 
     requires no processing and figure out how 
     many of the redundant packets are needed.
     Nfirstrec is the number of packets received
     from among the first Mpackets that carry portions
     of the unprocessed original message.
     Rec_index is an array that indicates which parts
     of the message are received.  The pattern is
     the same within all Nsegs segments,  */

  gettimeofday(&start_time,0); 

  Nfirstrec = 0;
  for (i=0; i < Mpackets; i++) 
    Rec_index[i] = 0;

  m = 0;
  for (i=0; i < Nrec; i++)
  {
    index = rec_packets[m];
    if (index < Mpackets)
    {
      j = index * Plen;
      Rec_index[index] = 1;
      for(row_eqn=0; row_eqn < Lfield; row_eqn++)
      {
	k = row_eqn * Nsegs;
	l = j + k;
	for (seg_ind=0; seg_ind < Nsegs; seg_ind++)
	  rec_message[seg_ind+l] = rec_packets[m+1+seg_ind+k];
      }
      Nfirstrec++;
    }
    m += Plentot;
  }

  /* Nextra is the number of redundant packets that need to be processed */
  Nextra = Mpackets - Nfirstrec;
#ifdef PRINT
  printf("Nfirstrec= %d, Nextra= %d \n",Nfirstrec,Nextra);
#endif

  /* Compute the indices of the missing words in the message */
  col_ind = 0;
  for (i=0; i < Mpackets; i++)
  {
    if (Rec_index[i] == 0)
      Col_Ind[col_ind++] = i;
  }

  /* Keep track of indices of extra packets in Row_Ind array
     and initialize M array from the received extra packets */
  row_ind = 0;
  m = 0;
  for(i=0; i < Nrec; i++)
  {
    if(rec_packets[m] >= Mpackets)
    {
      k = Nsegs*row_ind*Lfield;
      Row_Ind[row_ind] = rec_packets[m] - Mpackets;
      for(row_eqn=0; row_eqn < Lfield; row_eqn++) 
      {
	j = row_eqn*Nsegs;
	for (seg_ind=0; seg_ind < Nsegs; seg_ind++)
	{
	  M[k] = rec_packets[m+1+seg_ind+j];
	  k++;
	}
      }
      row_ind ++;
      if (row_ind >= Nextra)
	break; 
    }
    m += Plentot;
  }

  /* Adjust M array according to the equations and the contents of rec_message */

  for(row_ind = 0; row_ind < Nextra; row_ind++)
  {
    for(col_ind=0; col_ind < Mpackets; col_ind++)
    {
      if(Rec_index[col_ind] == 1)
      {   
	ExpFE = (SMultField - FEtoExp[Row_Ind[row_ind]^col_ind^COLBIT]) % SMultField;
	for(row_eqn=0; row_eqn < Lfield; row_eqn++)
	{
	  j = Nsegs*(row_eqn + row_ind*Lfield);
	  for(col_eqn=0; col_eqn < Lfield; col_eqn++)
	  {
	    k = Nsegs*(col_eqn + col_ind*Lfield);
	    if (ExptoFE[ExpFE+row_eqn] & BIT[col_eqn])
	    {
	      for(seg_ind=0; seg_ind < Nsegs; seg_ind++)
	      {
		M[j+seg_ind] ^= rec_message[k+seg_ind];
	      }
	    }
	  }
	}
      }
    }
  }

  /* Compute the determinant of the matrix in the finite field
     and then compute the inverse matrix */
  for(row_ind = 0; row_ind < Nextra; row_ind++)
  {
    for(col_ind = 0; col_ind < Nextra; col_ind++)
    {
      if(col_ind != row_ind)
      {
	C[row_ind] += FEtoExp[Row_Ind[row_ind]^Row_Ind[col_ind]];
	D[col_ind] += FEtoExp[Col_Ind[row_ind]^Col_Ind[col_ind]];
      }
      E[row_ind] += FEtoExp[Row_Ind[row_ind]^Col_Ind[col_ind]^COLBIT];
      F[col_ind] += FEtoExp[Row_Ind[row_ind]^Col_Ind[col_ind]^COLBIT];
    }
  }

  /* Fill in the recovered information in the message from
     the inverted matrix and from M */
  for (row_ind = 0; row_ind < Nextra; row_ind++)
  {
    for(col_ind = 0; col_ind < Nextra; col_ind++)
    {
      ExpFE = E[col_ind] + F[row_ind] - C[col_ind] - D[row_ind] 
	- FEtoExp[Row_Ind[col_ind]^Col_Ind[row_ind]^COLBIT];
      if (ExpFE < 0) ExpFE = SMultField-((-ExpFE) % SMultField);
      ExpFE = ExpFE % SMultField;
      j = Col_Ind[row_ind] * Lfield * Nsegs;
      for(row_eqn=0; row_eqn < Lfield; row_eqn++)
      {
	k = row_eqn*Nsegs + j;
	for(col_eqn=0; col_eqn < Lfield; col_eqn++)
	{
	  l = Nsegs *(col_eqn + col_ind*Lfield);
	  if(ExptoFE[ExpFE+row_eqn] & BIT[col_eqn])
	  {
	    for(seg_ind=0; seg_ind < Nsegs; seg_ind++)
	    {
	      rec_message[seg_ind+k] ^= M[l];
	      l++;
	    }
	  }
	}
      }
    }
  }

  gettimeofday(&end_time,0);

  total_time.tv_sec = (end_time.tv_sec-start_time.tv_sec);
  total_time.tv_usec = (end_time.tv_usec-start_time.tv_usec);

#ifdef PRINT
  printf ("\n------------------------------------------------");
  printf ("\n decode: number of seconds is %f",
	  (float)(total_time.tv_sec)+
	  (float)(total_time.tv_usec)/1000000.0); 
  printf ("\n------------------------------------------------\n\n");
  fflush(stdout);
#endif

  return total_time;
}

void Init_Field(int Lfield, int TableLength, int SMultField)
{
  /* POLYMASK is the irreducible polynomial */
  /* CARRYMASK is used to see when there is a carry in the polynomial
     and when it should be XOR'd with POLYMASK */

  int i ;

  available = 1;
  ExptoFE = (UNSIGNED *) calloc(TableLength+Lfield, sizeof(UNSIGNED));
  if (!(ExptoFE)) {printf("\ndriver: ExptoFE malloc failed\n"); exit(434); }

  FEtoExp = (UNSIGNED *) calloc(TableLength, sizeof(UNSIGNED));
  if (!(FEtoExp)) {printf("\ndriver: FEtoExp malloc failed\n"); exit(434); }


  /* Lfield is the length of the field (This can from the table above
     be between 1 and 15, but because of restrictions in the driver.c
     program this value currently can be at most 10).
     SMultField = TableLength - 1 is the number of elements in the 
     multiplicative group of the field.  COLBIT is used to make sure rows and 
     columns have distinct field elements associated with them   
     The BIT array is used to mask out single bits in equations: bit   
     ExptoFE is the table that goes from the exponent to the finite field 
     element FEtoExp is the table that goes from the finite field element to 
     the exponent */

  BIT[0] = 0x1 ;
  for(i=1; i < Lfield; i++) 
    BIT[i] = BIT[i-1] << 1;

  COLBIT = BIT[Lfield-1] ;
  CARRYMASK = COLBIT << 1 ;

  ExptoFE[0] = 0x1 ;

  for(i=1; i < SMultField + Lfield - 1; i++)
  {
    ExptoFE[i] = ExptoFE[i-1] << 1 ;
    if(ExptoFE[i]&CARRYMASK)
      ExptoFE[i] ^= POLYMASK[Lfield] ;
  }

  FEtoExp[0] = -1 ;
  for(i=0; i < SMultField ; i++)
    FEtoExp[ExptoFE[i]] = i ;
}

JNIEXPORT jlong JNICALL Java_ostore_archive_cauchy_NativeIF_cauchy_1encode_1using_1c_1helper(
	     JNIEnv *env         /* in  */,
	     jclass not_used     /* in  */,
	     jbyteArray msg      /* in  */,
	     jint Mfragments     /* in  */,
	     jint Rfragments     /* in  */,
	     jint Nsegs          /* in  */,
	     jint Lfield         /* in  */,
	     jintArray fragments /* out */)
{
  int Nfragments = Mfragments + Rfragments;
  int Plen = Nsegs * Lfield;
  int Plentot = Plen + 1;
  int i = 0;

  int num_ints = -1;
  UNSIGNED* conversion = NULL;
  struct timeval total_time;

  /* get (pin) fragment and message arrays. */
  jint* j_packets = (*env)->GetIntArrayElements(env, fragments, 0);
  UNSIGNED* packets = (UNSIGNED*)j_packets;
  jbyte *byte_msg = (*env)->GetByteArrayElements(env, msg, 0);
  UNSIGNED* message = (UNSIGNED*)byte_msg;

  /* convert from network byte order to host byte order. */
  num_ints = Mfragments*Plen;
  conversion = message;
  for(i = 0; i < num_ints; i++)
    conversion[i] = ntohl(conversion[i]);


  /* encode the message */
  total_time = encode(packets, message, Mfragments, Rfragments, Nsegs, Lfield);
  
  /* convert from host byte order to network byte order. */
  num_ints = Mfragments*Plen;
  conversion = message;
  for(i = 0; i < num_ints; i++)
    conversion[i] = htonl(conversion[i]);

  /* release (unpin) fragment and message arrays. */
  (*env)->ReleaseIntArrayElements(env, fragments, j_packets, 0);
  (*env)->ReleaseByteArrayElements(env, msg, byte_msg, JNI_ABORT);

  /* return time in microseconds. */
  return (jlong)((float)((total_time.tv_sec)*1000000.0)+
	  (float)(total_time.tv_usec));
}


JNIEXPORT jlong JNICALL Java_ostore_archive_cauchy_NativeIF_cauchy_1encode_1and_1verify_1using_1c_1helper(
	     JNIEnv *env         /* in  */,
	     jclass not_used     /* in  */,
	     jbyteArray msg      /* in  */,
	     jint Mfragments     /* in  */,
	     jint Rfragments     /* in  */,
	     jint Nsegs          /* in  */,
	     jint Lfield         /* in  */,
	     jintArray fragments /* out */,
	     jintArray intFrags2,
	     jbyteArray frags3,
	     jintArray message2,
	     jbyteArray message3)
{
  int Nfragments = Mfragments + Rfragments;
  int Plen = Nsegs * Lfield;
  int Plentot = Plen + 1;
  int i = 0;

  int num_ints = -1;
  UNSIGNED* conversion = NULL;
  struct timeval total_time;
  int die = 0;
#ifdef PRINT2
  unsigned char buf[32768];
#endif

  /* get (pin) fragment and message arrays. */
  jint* j_packets = (*env)->GetIntArrayElements(env, fragments, 0);
  UNSIGNED* packets = (UNSIGNED*)j_packets;
  jbyte *byte_msg = (*env)->GetByteArrayElements(env, msg, 0);
  UNSIGNED* message = (UNSIGNED*)byte_msg;
  
  jint* j_intFrags2 = (*env)->GetIntArrayElements(env, intFrags2, 0);
  UNSIGNED* c_intFrags2 = (UNSIGNED*)j_intFrags2;
  jbyte *j_frags3 = (*env)->GetByteArrayElements(env, frags3, 0);
  unsigned char* c_frags3 = (unsigned char*)j_frags3;

  jint* j_message2 = (*env)->GetIntArrayElements(env, message2, 0);
  UNSIGNED* c_message2 = (UNSIGNED*)j_message2;
  jbyte *j_message3 = (*env)->GetByteArrayElements(env, message3, 0);
  unsigned char* c_message3 = (unsigned char*)j_message3;
  

  /* convert from network byte order to host byte order. */
  num_ints = Mfragments*Plen;
  conversion = message;
  for(i = 0; i < num_ints; i++)
    conversion[i] = ntohl(conversion[i]);

#ifdef PRINT2
  /* Test arrays */
  die = 0;
  for(i = 0; i < num_ints; i++) {
    if(message[i] != c_message2[i]) {
      printf("message[%d]=%d != c_message[%d]=%d\n",i,message[i],i,c_message2[i]); fflush(NULL);
      die = 1;
    }
  }
  if(!die) {
    printf("  message=%s\n",
    print_bytes((jbyte*)message, 0, num_ints, buf));
    printf("c_message=%s\n", 
    print_bytes((jbyte*)c_message2, 0, num_ints, buf));
    printf(" message3=%s\n", 
    print_bytes((jbyte*)c_message3, 0, num_ints, buf));
    fflush(NULL);
  }
  
#endif

  /* encode the message */
  total_time = encode(packets, message, Mfragments, Rfragments, Nsegs, Lfield);

  /* convert from host byte order to network byte order. */  
  num_ints = Mfragments*Plen;
  conversion = message;
  for(i = 0; i < num_ints; i++)
    conversion[i] = htonl(conversion[i]);

#ifdef PRINT2
  if(!die) {
    num_ints = Nfragments*Plentot;
    printf("  intFrags=%s\n",
    print_bytes((jbyte*)packets, 0, num_ints, buf));
    printf("\nc_intFrags=%s",
    print_bytes((jbyte*)c_intFrags2, 0, num_ints, buf));
    printf("\n intFrags3=%s", 
    print_bytes((jbyte*)c_frags3, 0, num_ints, buf));
    fflush(NULL);
  }  
#endif


  /* release (unpin) fragment and message arrays. */
  (*env)->ReleaseIntArrayElements(env, intFrags2, j_intFrags2, JNI_ABORT);
  (*env)->ReleaseByteArrayElements(env, frags3, j_frags3, JNI_ABORT);

  (*env)->ReleaseIntArrayElements(env, message2, j_message2, JNI_ABORT);
  (*env)->ReleaseByteArrayElements(env, message3, j_message3, JNI_ABORT);

  (*env)->ReleaseIntArrayElements(env, fragments, j_packets, 0);
  (*env)->ReleaseByteArrayElements(env, msg, byte_msg, JNI_ABORT);


  /* return time in microseconds. */
  return (jlong)((float)((total_time.tv_sec)*1000000.0)+
	  (float)(total_time.tv_usec));
}


JNIEXPORT jlong JNICALL Java_ostore_archive_cauchy_NativeIF_cauchy_1decode_1using_1c_1helper(
	     JNIEnv *env             /* in  */,
	     jclass not_used         /* in  */,
	     jbyteArray rec_fragments/* out */,
	     jint Nrec               /* in  */,
	     jint Mfragments         /* in  */,
	     jint Rfragments         /* in  */,
	     jint Nsegs              /* in  */,
	     jint Lfield             /* in  */,
	     jintArray rec_msg       /* in  */)
{
  int Nfragments = Mfragments + Rfragments;
  int Plen = Nsegs * Lfield;
  int Plentot = Plen + 1;
  int i = 0;

  int num_ints = -1;
  UNSIGNED* conversion = NULL;
  struct timeval total_time;

  jint *j_rec_packets = (*env)->GetIntArrayElements(env, rec_fragments, 0);
  UNSIGNED* rec_packets = (UNSIGNED*)j_rec_packets;
  jbyte *rec_byte_msg = (*env)->GetByteArrayElements(env, rec_msg, 0);
  UNSIGNED* rec_message = (UNSIGNED*)rec_byte_msg;

  /* encode the message */
  total_time = decode(rec_message, rec_packets, Nrec, Mfragments, Rfragments, Nsegs, Lfield);

  /* convert from host byte order to network byte order. */
  num_ints = Mfragments*Plen;
  conversion = rec_message;
  for(i = 0; i < num_ints; i++)
    conversion[i] = htonl(conversion[i]);

  /* release (unpin) fragment and message arrays. */
  (*env)->ReleaseIntArrayElements(env, rec_fragments, j_rec_packets, JNI_ABORT);
  (*env)->ReleaseByteArrayElements(env, rec_msg, rec_byte_msg, 0);

  /* return time in microseconds. */  
  return (jlong)((float)(total_time.tv_sec*1000000.0)+
		 (float)(total_time.tv_usec));
}
