//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: Zachary Mark
//
// Date: Nov 29, 2007
//---------------------

package org.cleversafe.authentication;

import java.util.List;

import javax.security.auth.login.Configuration;

// Interface which describes the behavior of an object which provides different methods
// of authentication.  
public interface AuthenticationFacilitator
{
   public AuthenticationFacilitatorConfiguration getConfiguration();
   
   public void setConfiguration(AuthenticationFacilitatorConfiguration config);
   
   /**
    * Attempt to authenticate with the given credentials.  The implementing class
    * should determine the login method to be used.
    * 
    * @param credentials  The user credentials to be examined.
    * @return True if authentication was successful, false otherwise.
    */
   public boolean attemptAuthentication(Credentials credentials);
   
   /**
    * Attempt to authenticate with the given credentials.
    * 
    * @param credentials  The user credentials to be examined.
    * @param method The login method to be used.
    * @return True if authentication was successful, false otherwise.
    */
   public boolean attemptAuthentication(Credentials credentials, String method);
}
