//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: Zachary Mark
//
// Date: Nov 29, 2007
//---------------------

package org.cleversafe.authentication;

import java.util.Map;

import org.cleversafe.authentication.exceptions.AuthenticationConfigurationException;

// Marker interface to allow AuthenticationFacilitator to accept various types of configurations.
public interface AuthenticationFacilitatorConfiguration
{
   public enum ModuleControlFlag
   {
      OPTIONAL, REQUIRED, REQUISITE, SUFFICIENT
   }

   public String getDefaultMethod();

   public void setDefaultMethod(String defaultMethod);

   public void addAuthenticationMethod(
         String methodName,
         Class<?> className,
         ModuleControlFlag controlFlag,
         Map<String, String> options) throws AuthenticationConfigurationException;
}
