//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Jun 7, 2007
//---------------------

package org.cleversafe.authentication.credentials;
import java.util.UUID;

import org.cleversafe.authentication.Credentials;
import org.cleversafe.util.UUIDGen;

/**
 * Represents credentials consisting of a username and password. These credentials are applicable
 * for any authentication mechanism that needs only those values.
 * <p>
 * For these credentials the grid account identifier is a type 3 (name based) <code>UUID</code>
 * generated from the username. The limitation imposed here is that grid indirectly depends on the
 * username, which therefore cannot be changed after account creation. 
 *
 * @author Wesley Leggette
 */
public class PasswordCredentials implements Credentials
{
   private UUID accountIdentifier;
   private String username;
   private String password;
   
   public PasswordCredentials()
   {
      this.username = null;
      this.password = null;
      this.accountIdentifier = null;
   }
   
   public PasswordCredentials(String username, String password)
   {
      this.setUsername(username);
      this.setPassword(password);
   }
   
   public UUID getAccountIdentifier()
   {
      return accountIdentifier;
   }

   public String getPassword()
   {
      return password;
   }

   public void setPassword(String password)
   {
      this.password = password;
   }

   public String getUsername()
   {
      return username;
   }

   public void setUsername(String username)
   {
      this.username = username;
      this.accountIdentifier = UUIDGen.getUUIDFromUsername( username );
   }

   @Override
   public int hashCode()
   {
      final int prime = 31;
      int result = 1;
      result = prime * result + ((accountIdentifier == null) ? 0 : accountIdentifier.hashCode());
      result = prime * result + ((password == null) ? 0 : password.hashCode());
      result = prime * result + ((username == null) ? 0 : username.hashCode());
      return result;
   }

   @Override
   public boolean equals(Object obj)
   {
      if (this == obj)
         return true;
      if (obj == null)
         return false;
      if (getClass() != obj.getClass())
         return false;
      final PasswordCredentials other = (PasswordCredentials) obj;
      if (accountIdentifier == null)
      {
         if (other.accountIdentifier != null)
            return false;
      }
      else if (!accountIdentifier.equals(other.accountIdentifier))
         return false;
      if (password == null)
      {
         if (other.password != null)
            return false;
      }
      else if (!password.equals(other.password))
         return false;
      if (username == null)
      {
         if (other.username != null)
            return false;
      }
      else if (!username.equals(other.username))
         return false;
      return true;
   }
   
   

}


