//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: May 13, 2007
//---------------------

package org.cleversafe.config;

import java.util.List;

import org.apache.log4j.Logger;
import org.cleversafe.config.evaluator.SimpleParameter;
import org.cleversafe.config.exceptions.ConfigurationException;
import org.cleversafe.config.exceptions.ObjectInitializationException;
import org.cleversafe.config.exceptions.ObjectInstantiationException;

// This class is used to instntiate implementation objects from configuration

public class InterfaceImplementationFactory extends ImplementationFactoryBase
{
   private static Logger _logger = Logger.getLogger(InterfaceImplementationFactory.class);
   Class<?> interfaceClass;

   /**
    * 
    * @param interfaceName
    * @param implementationName
    * @param initializers
    * @throws ObjectInstantiationException
    * @throws ConfigurationException
    */
   public InterfaceImplementationFactory(
         final String interfaceName,
         final String implementationName,
         final List<SimpleParameter> parameters) throws ClassNotFoundException,
         ObjectInstantiationException
   {
      super(implementationName, parameters);
      this.interfaceClass = Class.forName(interfaceName);

      // Check that the specified class implements the specified interface
      if (!this.interfaceClass.isAssignableFrom(getImplementationClass()))
      {
         throw new IllegalArgumentException("Class '" + implementationName
               + "' doesn't implement '" + interfaceName + "'");
      }
      _logger.debug("Class '" + getImplementationClass().getName() + "' is used for "
            + this.interfaceClass.getName() + " implementation");
   }

   public InterfaceImplementationFactory(
         final Class<?> interfaceClass,
         final Class<?> implementationClass,
         final List<SimpleParameter> parameters) throws ObjectInstantiationException
   {
      super(implementationClass, parameters);
      this.interfaceClass = interfaceClass;

      // Check that a specified class implements a specified interface
      if (!this.interfaceClass.isAssignableFrom(getImplementationClass()))
      {
         throw new IllegalArgumentException("Class '" + implementationClass.getName()
               + "' doesn't implement '" + interfaceClass.getName() + "'");
      }
      _logger.debug("Class '" + getImplementationClass().getName() + "' is used for "
            + this.interfaceClass.getName() + " implementation");
   }

   /*
    * Return a concrete object of class implementationName
    */
   public Object getInterfaceImplementation() throws ObjectInitializationException,
         ObjectInstantiationException
   {
      final Object classInstance = super.getImplementationObject();
      _logger.debug("Implementation for interface '" + this.interfaceClass.getName()
            + "' successfully created");
      return classInstance;
   }

   /**
    * @return the interfaceClass
    */
   public Class<?> getInterfaceClass()
   {
      return this.interfaceClass;
   }

}
