//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Dec 8, 2007
//---------------------

package org.cleversafe.control;

/**
 * A class represents integer value state
 * Not thread safe
 */
public class IntegerParameter implements ParameterState
{
   private final int currentValue;

   /**
    * 
    * @param originalState
    */
   IntegerParameter(int originalState)
   {
      this.currentValue = originalState;
   }

   public ParameterState advance()
   {
      return new IntegerParameter(this.currentValue + 1);
   }

   public ParameterState reverse()
   {
      return new IntegerParameter(this.currentValue - 1);
   }

  
   public int compareTo(ParameterState other)
   {
      // the same class
      if (other == null)
      {
         throw new IllegalArgumentException ("Can't compare with null");
      }
      if (other.getClass().isAssignableFrom(this.getClass())
            && this.getClass().isAssignableFrom(other.getClass()))
      {
         IntegerParameter otherIntegerState = (IntegerParameter) other;
         return this.getStateValue() - otherIntegerState.getStateValue();
      }
      throw new IllegalArgumentException("Trying to compare " + this.getClass().getName() + " and "
            + other.getClass().getName());
   }

   public boolean equals (Object other)
   {
      if (other == null) 
      {
         return false;
      }
      if (other.getClass().isAssignableFrom(this.getClass())
            && this.getClass().isAssignableFrom(other.getClass()))
      {     
         IntegerParameter otherIntegerState = (IntegerParameter) other;
         return this.getStateValue() == otherIntegerState.getStateValue();
      }
      else {
         return false;
      }
   }

   /**
    * @return the currentState
    */
   public int getStateValue()
   {
      return currentValue;
   }
   /**
    * String representation
    */
   public String toString()
   {
      return "IntegerState=" + this.currentValue;
   }

}
