//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Dec 8, 2007
//---------------------

package org.cleversafe.control;

/**
 * State represented by integer but value should be in a given scope
 */
public class IntegerRangeParameter extends IntegerParameter
{
   /** 
    * State will not fall below min value
    */
   private final int minValue;

   /** 
    * State will not exceed max value
    */
   private final int maxValue;

   /**
    * Creates a range with limits imposed
    * @param originalValue
    * @param minValue
    * @param maxValue
    */
   public IntegerRangeParameter(int originalValue, int minValue, int maxValue)
   {
      super(originalValue);
      this.minValue = minValue;
      this.maxValue = maxValue;
      if (minValue > maxValue || originalValue < minValue || originalValue > maxValue)
      {
         throw new IllegalArgumentException("Invalid range values: " + originalValue + ", " + minValue
               + ", " + maxValue);
      }
   }

   /**
    * @see org.cleversafe.control.SystemStateadvance()
    */
   public ParameterState advance()
   {
      if (this.getStateValue() == this.maxValue)
      {
         return this;
      }
      else
      {
         return new IntegerRangeParameter(this.getStateValue()+1, this.minValue, this.maxValue);
      }
   }

   /*
    * @see org.cleversafe.control.SystemState#reverse()
    */
   public ParameterState reverse()
   {
      if (this.getStateValue() == this.minValue)
      {
         return this;
      }
      else
         return new IntegerRangeParameter(this.getStateValue()-1, this.minValue, this.maxValue);
   }

   /**
    * String representation
    */
   public String toString()
   {
      return "RangeIntegerState:" + this.getStateValue();
   }
}
