//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Dec 8, 2007
//---------------------

package org.cleversafe.control;

/*
 * This interface provides a notion of ranked parameters
 * State knows what is the next and what is previous
 */
public interface ParameterState extends Comparable<ParameterState>
{
   /**
    * Advances to a new state
    * Semantics: this.compareTo(this.advance()) >= 0 // may not change
    */
   ParameterState advance();
   
   /**
    * Reverses one state
    * Semantics: this.compareTo(this.reverse()) <= 0 // may not change
    * @return
    */
   ParameterState reverse();  
   /**
    * Must implement equality
    */ 
   boolean equals(Object state);
   /**
    * Must implement comparison
    * @return 0 if equals, 1 is greater, -1 is less then.
    * advance operation should move from lesser to greater
    */
   int compareTo(ParameterState state);
}


