//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: mmotwani
//
// Date: May 2, 2007
//---------------------

package org.cleversafe.exceptions;

import org.apache.log4j.Logger;

/**
 * The base exception class. All abnormal conditions should throw this exception or its derived
 * exception.
 * 
 * @author Manish Motwani
 */
public abstract class BaseException extends Exception
{
   private static final long serialVersionUID = 1447875592638268609L;

   private static Logger _logger = Logger.getLogger(BaseException.class);

   public BaseException()
   {
      super();
      if (_logger.isTraceEnabled())
         _logger.trace("Exception", this);
   }

   public BaseException(String reason, Throwable cause)
   {
      super(reason == null ? "" : reason, cause);
      if (_logger.isTraceEnabled())
         _logger.trace("Exception: " + reason, this);
   }

   public BaseException(String reason)
   {
      super(reason);
      if (_logger.isTraceEnabled())
         _logger.trace("Exception: " + reason, this);
   }

   public BaseException(Throwable cause)
   {
      super(cause);
      if (_logger.isTraceEnabled())
         _logger.trace("Exception", this);
   }

   public String getMessage()
   {
      return super.getMessage();
   }

   public String toString()
   {
      StringBuffer fullMessage = new StringBuffer();

      if (getMessage() != null)
      {
         fullMessage.append(getMessage());
      }
      else
      {
         fullMessage.append("(No message provided)");
      }

      if (getCause() != null)
      {
         fullMessage.append(", Caused by: ");
         if (getCause().getMessage() != null)
         {
            fullMessage.append(getCause().getMessage());
         }
         else // better class name then nothing
         {
            fullMessage.append(getCause().getClass().getName());
         }
      }
      return fullMessage.toString();
   }
}
