//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: gdhuse
//
// Date: May 8, 2007
//---------------------

package org.cleversafe.ida;

import org.cleversafe.ida.exceptions.IDAInvalidParametersException;
import org.cleversafe.ida.exceptions.IDANotInitializedException;

/**
 * IDA interface - combines an encoder and decoder
 */
public interface InformationDispersalCodec
{
   /**
    * Perform initialization to ready codec for encoding or decoding
    */
   public void initialize() throws IDAInvalidParametersException;;
   
   /**
    * 
    * @return a name of codec
    */
   String getName();
   
   /**
    * @return Number of slices produced by this codec
    */
   int getNumSlices();
   
   /**
    * @return Number of slices needed to restore data
    */
   int getThreshold();
   
   /**
    * @return The chunk size on which the IDA will operate
    */
   int getChunkSize();

   /**
    * Sets number of slices, needed for instantiating from configuration
    * @param numSlices
    */
   void setNumSlices(int numSlices);
   
   /**
    * Number of slices needed to restore data
    * @param treshold
    */
   void setThreshold(int threshold);
   
   /**
    * Chunk size for which the IDA will operate, typically the disk block size
    * plus overhead due to datasource codecs
    * @param inputSize
    */
   void setChunkSize(int inputSize);
   
   /**
    * 
    * @return
    */
   InformationDispersalEncoder getEncoder() throws IDANotInitializedException;

   /**
    * 
    * @return
    */
   InformationDispersalDecoder getDecoder() throws IDANotInitializedException;
   
   /**
    * Returns the blowup of this IDA.  For example, if encoded data is 30% larger than 
    * the original input, this would return 1.3.
    * @return Blowup of this IDA as a factor of the original data size (eg. 1.3)
    */
   float getBlowup();
   
   /**
    * Returns the post-dispersed upper-bound size in bytes for data with a given input size.
    * 
    * @param inputDataSize
    * @return
    */
   long getDispersedSize(long inputSize);

}


