//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: John Quigley <jquigley@cleversafe.com>
//
// Date: Sep 13, 2007
//---------------------

package org.cleversafe.layer.communication;

import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.serialization.ProtocolMessageFactory;
import org.cleversafe.server.ClientSession;
import org.cleversafe.server.ServerApplication;
import org.cleversafe.server.exceptions.ServerIOException;

/**
 * An Acceptor for client connection and communication
 * 
 */
public interface Acceptor
{
   public Response receive(ClientSession session, Request request);

   public void setServerApplication(ServerApplication serverApplication);

   public void setProtocolMessageFactory(ProtocolMessageFactory protocolMessageFactory);

   public void start() throws ServerIOException;

   public void stop();

   public boolean isRunning();
}
