//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: gdhuse
//
// Date: Mar 7, 2008
//---------------------

package org.cleversafe.layer.communication.network.mina;

import java.util.concurrent.Executor;

import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;

/**
 * Mina's ExcecutorFilter does not fully utilize an executor.  This
 * class is an adaptation that passes all events directly to the executor
 */
public class ExecutorFilter extends IoFilterAdapter
{
   // private static Logger _logger = Logger.getLogger(ExecutorFilter.class);

   private final Executor executor;

   /**
    * Creates a new instance with the specified <tt>executor</tt>.
    */
   public ExecutorFilter(Executor executor)
   {
      if (executor == null)
      {
         throw new NullPointerException("executor");
      }

      this.executor = executor;
   }

   /**
    * Returns the underlying {@link Executor} instance this filter uses.
    */
   public Executor getExecutor()
   {
      return executor;
   }

   /**
    * IoFilterAdapter interface implementations
    */
   
   public void messageReceived(
         final NextFilter nextFilter,
         final IoSession session,
         final Object data)
   {
      this.executor.execute(new Runnable()
      {
         public void run()
         {
            nextFilter.messageReceived(session, data);
         }
      });
   }

   public void sessionCreated(NextFilter nextFilter, IoSession session)
   {
      nextFilter.sessionCreated(session);
   }

   public void sessionOpened(final NextFilter nextFilter, final IoSession session)
   {
      nextFilter.sessionOpened(session);
   }

   public void sessionClosed(final NextFilter nextFilter, final IoSession session)
   {
      nextFilter.sessionClosed(session);
   }

   public void sessionIdle(
         final NextFilter nextFilter,
         final IoSession session,
         final IdleStatus status)
   {
      nextFilter.sessionIdle(session, status);
   }

   public void exceptionCaught(
         final NextFilter nextFilter,
         final IoSession session,
         final Throwable cause)
   {
      nextFilter.exceptionCaught(session, cause);
   }

   public void messageSent(final NextFilter nextFilter, final IoSession session, final Object data)
   {
      nextFilter.messageSent(session, data);
   }

   public void filterWrite(NextFilter nextFilter, IoSession session, WriteRequest writeRequest)
   {
      nextFilter.filterWrite(session, writeRequest);
   }

   public void filterClose(NextFilter nextFilter, IoSession session) throws Exception
   {
      nextFilter.filterClose(session);
   }
}
