//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER

/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */

package org.cleversafe.layer.communication.network.mina.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;

import javax.net.SocketFactory;

/**
 * Simple Socket factory to create sockets with or without SSL enabled. If SSL enabled a "bougus"
 * SSL Context is used (suitable for test purposes)
 */
public class SSLSocketFactory extends SocketFactory
{
   private static boolean sslEnabled = false;

   private static javax.net.ssl.SSLSocketFactory sslFactory = null;

   private static javax.net.SocketFactory factory = null;

   public SSLSocketFactory()
   {
      super();
   }

   public Socket createSocket(String arg1, int arg2) throws IOException, UnknownHostException
   {
      if (isSslEnabled())
      {
         return getSSLFactory().createSocket(arg1, arg2);
      }
      else
      {
         return new Socket(arg1, arg2);
      }
   }

   public Socket createSocket(String arg1, int arg2, InetAddress arg3, int arg4)
         throws IOException, UnknownHostException
   {
      if (isSslEnabled())
      {
         return getSSLFactory().createSocket(arg1, arg2, arg3, arg4);
      }
      else
      {
         return new Socket(arg1, arg2, arg3, arg4);
      }
   }

   public Socket createSocket(InetAddress arg1, int arg2) throws IOException
   {
      if (isSslEnabled())
      {
         return getSSLFactory().createSocket(arg1, arg2);
      }
      else
      {
         return new Socket(arg1, arg2);
      }
   }

   public Socket createSocket(InetAddress arg1, int arg2, InetAddress arg3, int arg4)
         throws IOException
   {
      if (isSslEnabled())
      {
         return getSSLFactory().createSocket(arg1, arg2, arg3, arg4);
      }
      else
      {
         return new Socket(arg1, arg2, arg3, arg4);
      }
   }

   public static javax.net.SocketFactory getSocketFactory()
   {
      if (factory == null)
      {
         factory = new SSLSocketFactory();
      }
      return factory;
   }

   private javax.net.ssl.SSLSocketFactory getSSLFactory()
   {
      if (sslFactory == null)
      {
         try
         {
            sslFactory = SSLContextFactory.getInstance(false, null, null).getSocketFactory();
         }
         catch (GeneralSecurityException e)
         {
            throw new RuntimeException("could not create SSL socket", e);
         }
      }
      return sslFactory;
   }

   public static boolean isSslEnabled()
   {
      return sslEnabled;
   }

   public static void setSslEnabled(boolean newSslEnabled)
   {
      sslEnabled = newSslEnabled;
   }
}
